/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import shaded.top.infra.maven.shared.utils.SupportFunction;
import top.infra.maven.logging.Logger;

public abstract class DownloadUtils {
    private DownloadUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map.Entry<Optional<Integer>, Optional<Exception>> download(Logger logger, String fromUrl, Path saveToFile, Map<String, String> headers, int maxTry) {
        Exception lastException = null;
        Integer lastStatus = null;
        int count = 0;
        while (count < maxTry) {
            ++count;
            String newUrl = null;
            InputStream inputStream = null;
            try {
                boolean redirect;
                URL source = new URL(fromUrl);
                HttpURLConnection urlConnection = (HttpURLConnection)source.openConnection();
                urlConnection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(10L));
                urlConnection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(20L));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("    HttpURLConnection header names: %s", headers != null ? headers.keySet() : null));
                }
                if (headers != null && headers.size() > 0) {
                    headers.forEach(urlConnection::setRequestProperty);
                }
                inputStream = urlConnection.getInputStream();
                int status = urlConnection.getResponseCode();
                lastException = null;
                lastStatus = status;
                boolean bl = redirect = lastStatus == 302 || lastStatus == 301 || lastStatus == 303;
                if (redirect) {
                    newUrl = urlConnection.getHeaderField("Location");
                    logger.info(String.format("    Download redirect ('%s' to '%s'). %s", fromUrl, newUrl, status));
                } else {
                    newUrl = null;
                    logger.info(String.format("    Download result ('%s' to '%s'). %s", fromUrl, saveToFile, status));
                }
            }
            catch (FileNotFoundException ex) {
                logger.warn(String.format("    Download error ('%s' to '%s'). %s", fromUrl, saveToFile, "Not found"));
                lastException = null;
                lastStatus = 404;
            }
            catch (SocketTimeoutException ex) {
                logger.warn(String.format("    Download timeout ('%s' to '%s'). %s", fromUrl, saveToFile, ex.getMessage()));
                lastException = ex;
                lastStatus = null;
            }
            catch (Exception ex) {
                logger.warn(String.format("    Download error ('%s' to '%s'). %s", fromUrl, saveToFile, ex.getMessage()), ex);
                lastException = ex;
                lastStatus = null;
            }
            if (inputStream != null) {
                if (newUrl != null) {
                    return DownloadUtils.download(logger, newUrl, saveToFile, headers, maxTry);
                }
                if (DownloadUtils.is2xxStatus(lastStatus)) {
                    File saveToDir = saveToFile.toFile().getParentFile();
                    try {
                        if (!saveToDir.exists()) {
                            Files.createDirectories(Paths.get(saveToDir.toString(), new String[0]), new FileAttribute[0]);
                        }
                    }
                    catch (IOException ex) {
                        return SupportFunction.newTupleOptional(lastStatus, ex);
                    }
                    try (ReadableByteChannel rbc = Channels.newChannel(inputStream);){
                        try (FileOutputStream fos = new FileOutputStream(saveToFile.toFile());){
                            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                        }
                        Map.Entry<Optional<Integer>, Optional<Exception>> entry = SupportFunction.newTupleOptional(lastStatus, null);
                        return entry;
                    }
                    catch (IOException ex) {
                        return SupportFunction.newTupleOptional(lastStatus, ex);
                    }
                }
                if (lastStatus == null || DownloadUtils.is5xxStatus(lastStatus)) continue;
                return SupportFunction.newTupleOptional(lastStatus, null);
            }
            if (lastStatus == null || lastStatus != 404) continue;
            return SupportFunction.newTupleOptional(lastStatus, null);
        }
        return SupportFunction.newTupleOptional(lastStatus, lastException);
    }

    public static boolean is2xxStatus(Integer status) {
        return status != null && status >= 200 && status < 300;
    }

    public static boolean is404Status(Integer status) {
        return status != null && status == 404;
    }

    public static boolean is5xxStatus(Integer status) {
        return status != null && status >= 500 && status < 600;
    }

    public static class DownloadException
    extends RuntimeException {
        public DownloadException(String msg) {
            super(msg);
        }

        public DownloadException(String msg, Exception cause) {
            super(msg, cause);
        }

        public DownloadException(Exception cause) {
            super(cause);
        }
    }
}

