/*
 * Decompiled with CFR 0.152.
 */
package shaded.top.infra.maven.shared.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shaded.top.infra.maven.shared.exception.RuntimeIOException;

public abstract class SupportFunction {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private SupportFunction() {
    }

    public static List<String> asList(String[] array1, String ... array2) {
        return Arrays.asList(SupportFunction.concat(array1, array2));
    }

    public static String componentName(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("(.)(\\p{Lu})", "$1_$2").toUpperCase();
    }

    public static boolean componentDisabled(Class<?> clazz, Properties systemProperties, Properties userProperties) {
        String name = SupportFunction.componentName(clazz);
        String envVar = "env.CI_OPT_" + name + "_DISABLED";
        String propName = name.toLowerCase().replace('_', '-') + ".disabled";
        return Boolean.parseBoolean(systemProperties.getProperty(envVar, userProperties.getProperty(propName, "false")));
    }

    public static String[] concat(String[] array1, String ... array2) {
        return (String[])Stream.of(array1, array2).flatMap(Stream::of).toArray(String[]::new);
    }

    public static boolean exists(Path path) {
        return path != null && path.toFile().exists();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static List<String> lines(String cmdOutput) {
        return Arrays.stream(("" + cmdOutput).split("\\r?\\n")).map(line -> line.replaceAll("\\s+", " ")).filter(SupportFunction::isNotEmpty).collect(Collectors.toList());
    }

    public static boolean isNotEmpty(String str) {
        return !SupportFunction.isEmpty(str);
    }

    public static List<Map.Entry<String, List<String>>> commonPrefixes(List<String> names) {
        LinkedList<Map.Entry<String, List<String>>> result = new LinkedList<Map.Entry<String, List<String>>>();
        ArrayList<String> randomAccess = new ArrayList<String>(names);
        int size = randomAccess.size();
        String lastCommonPrefix = "";
        LinkedList<String> currentGroup = new LinkedList<String>();
        for (int idx = 0; idx < size; ++idx) {
            String ccPrefix;
            boolean hasCommonPrefix;
            String next;
            String current = (String)randomAccess.get(idx);
            String cPrefix = SupportFunction.commonPrefix(current, next = idx + 1 != size ? (String)randomAccess.get(idx + 1) : null);
            if (cPrefix.isEmpty()) {
                hasCommonPrefix = false;
                ccPrefix = "";
            } else {
                ccPrefix = lastCommonPrefix.isEmpty() ? cPrefix : SupportFunction.commonPrefix(lastCommonPrefix, cPrefix);
                boolean containsUnderscore = ccPrefix.contains("_");
                boolean bl = ccPrefix.startsWith("env.") ? containsUnderscore : (hasCommonPrefix = containsUnderscore || ccPrefix.contains("."));
            }
            if (hasCommonPrefix) {
                currentGroup.add(current);
            } else {
                currentGroup.add(current);
                result.add(SupportFunction.newTuple(lastCommonPrefix, currentGroup));
                currentGroup = new LinkedList();
            }
            lastCommonPrefix = hasCommonPrefix ? ccPrefix : "";
        }
        return result;
    }

    private static String commonPrefix(String o1, String o2) {
        String result;
        if (o1 != null && o2 != null) {
            char charAtIdx;
            StringBuilder sb = new StringBuilder();
            for (int idx = 0; idx < o1.length() && idx < o2.length() && (charAtIdx = o1.charAt(idx)) == o2.charAt(idx); ++idx) {
                sb.append(charAtIdx);
            }
            result = sb.toString();
        } else {
            result = "";
        }
        return result;
    }

    public static <F, S> Map.Entry<F, S> newTuple(F first, S second) {
        return new AbstractMap.SimpleImmutableEntry<F, S>(first, second);
    }

    public static <F, S> Map.Entry<Optional<F>, Optional<S>> newTupleOptional(F first, S second) {
        return new AbstractMap.SimpleImmutableEntry<Optional<F>, Optional<S>>(Optional.ofNullable(first), Optional.ofNullable(second));
    }

    public static boolean notEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static String stackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String uniqueKey() {
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            salt.update(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            return SupportFunction.bytesToHex(salt.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String logStart(Object obj, String methodName, Object ... args) {
        return String.format(" >>> %s#%s%s --- hashCode: [%s] @ %s >>>", obj.getClass().getSimpleName(), methodName, SupportFunction.argsToStr(args), obj.hashCode(), SupportFunction.module(obj));
    }

    public static String logEnd(Object obj, String methodName, Object returns, Object ... args) {
        return String.format(" <<< %s#%s%s%s --- hashCode: [%s] @ %s <<<", obj.getClass().getSimpleName(), methodName, SupportFunction.argsToStr(args), SupportFunction.returnsToStr(returns), obj.hashCode(), SupportFunction.module(obj));
    }

    private static String returnsToStr(Object returns) {
        return returns != Void.TYPE && returns != Void.class ? String.format(" -> %s", returns) : "";
    }

    private static String argsToStr(Object ... args) {
        return args.length > 0 ? "(" + Stream.of(args).map(Object::toString).collect(Collectors.joining(", ")) + ")" : "";
    }

    public static String module(Object obj) {
        Properties moduleInfo = new Properties();
        try {
            moduleInfo.load(obj.getClass().getClassLoader().getResourceAsStream("module-info.properties"));
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
        return String.format("%s:%s", moduleInfo.getProperty("artifactId", "unknown"), moduleInfo.getProperty("version", "unknown"));
    }
}

