/*
 * Decompiled with CFR 0.152.
 */
package top.infra.maven.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public abstract class ClassPathUtils {
    private ClassPathUtils() {
    }

    private static <T> Class<T> classForName(String className) {
        return Class.forName(className);
    }

    public static <T> Set<Class<T>> scan(String basePackage, TypeFilter includeFilter) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)basePackage));
        ClassPathScanningCandidateProvider provider = new ClassPathScanningCandidateProvider();
        provider.addIncludeFilter(includeFilter);
        Set beanDefinitions = provider.findCandidateComponents(basePackage.replaceAll("\\.", "/"));
        LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            result.add(ClassPathUtils.classForName(beanDefinition.getBeanClassName()));
        }
        return result;
    }

    public static class ClassPathScanningCandidateProvider
    extends ClassPathScanningCandidateComponentProvider {
        public ClassPathScanningCandidateProvider() {
            super(false);
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return beanDefinition.getMetadata().isIndependent();
        }
    }

    public static class InterfaceFilter
    extends AbstractClassTestingTypeFilter {
        private final Class<?> type;

        protected boolean match(ClassMetadata metadata) {
            return ArrayUtils.contains((Object[])metadata.getInterfaceNames(), (Object)this.type.getName());
        }

        @ConstructorProperties(value={"type"})
        public InterfaceFilter(Class<?> type) {
            this.type = type;
        }
    }
}

