/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.rsync.external.ExternalWagon;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractExternalWagon
extends AbstractWagon
implements ExternalWagon {
    static final String RSYNC_PASSWORD = "RSYNC_PASSWORD";

    protected void closeConnection() throws ConnectionException {
    }

    protected abstract Commandline createBaseCommandLine(File var1, String ... var2);

    @Override
    public void executeCopyCommand(Resource resource, File localFile, boolean put, String ... options) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String resourceName = AbstractExternalWagon.normalizeResource(resource);
        String remoteFile = this.getRepository().getBasedir() + AbstractExternalWagon.prefixSlash(resourceName);
        this.executeCopyCommand(resource, remoteFile, localFile, put, options);
    }

    @Override
    public void executeCopyCommand(Resource resource, String remoteFile, File localFile, boolean put, String ... options) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String localFileName;
        File privateKey;
        boolean sshOrScp;
        boolean bl = sshOrScp = this.getRepository().getProtocol().contains("ssh") || this.getRepository().getProtocol().contains("scp");
        if (sshOrScp) {
            try {
                privateKey = ScpHelper.getPrivateKey((AuthenticationInfo)this.getAuthenticationInfo());
            }
            catch (FileNotFoundException e) {
                this.fireSessionConnectionRefused();
                throw new AuthorizationException(e.getMessage());
            }
        } else {
            privateKey = null;
        }
        Commandline cl = this.createBaseCommandLine(privateKey, options);
        cl.setWorkingDirectory(localFile.getParentFile().getAbsolutePath());
        if (!sshOrScp && this.getAuthenticationInfo().getPassword() != null) {
            cl.addEnvironment(RSYNC_PASSWORD, this.getAuthenticationInfo().getPassword());
        }
        String remoteHost = this.buildRemoteHost();
        String qualifiedRemoteFile = remoteHost + (remoteHost.contains(":") ? "" : ":") + StringUtils.replace((String)(options.length > 0 ? AbstractExternalWagon.suffixSlash(remoteFile) : remoteFile), (String)" ", (String)"\\ ");
        String string = localFileName = options.length > 0 ? AbstractExternalWagon.suffixSlash(localFile.getName()) : localFile.getName();
        if (put) {
            cl.createArg().setValue(localFileName);
            cl.createArg().setValue(qualifiedRemoteFile);
        } else {
            cl.createArg().setValue(qualifiedRemoteFile);
            cl.createArg().setValue(localFileName);
        }
        this.fireSessionDebug("Executing command: " + cl.toString());
        try {
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)err);
            if (exitCode != 0) {
                if (!put && err.getOutput().trim().toLowerCase(Locale.ENGLISH).contains("no such file or directory")) {
                    throw new ResourceDoesNotExistException(err.getOutput());
                }
                TransferFailedException e = new TransferFailedException("Exit code: " + exitCode + " - " + err.getOutput());
                this.fireTransferError(resource, (Exception)e, put ? 6 : 5);
                throw e;
            }
        }
        catch (CommandLineException ex) {
            this.fireTransferError(resource, (Exception)((Object)ex), put ? 6 : 5);
            throw new TransferFailedException("Error executing command line", (Throwable)ex);
        }
    }

    public void fireTransferDebug(String message) {
        super.fireTransferDebug(message);
    }

    public void fireSessionDebug(String message) {
        super.fireSessionDebug(message);
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String path = AbstractExternalWagon.normalize(resourceName);
        Resource resource = new Resource(path);
        this.fireGetInitiated(resource, destination);
        this.createParentDirectories(destination);
        this.fireGetStarted(resource, destination);
        this.executeCopyCommand(resource, destination, false, new String[0]);
        this.postProcessListeners(resource, destination, 5);
        this.fireGetCompleted(resource, destination);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fireSessionDebug("getIfNewer in SSH wagon is not supported - performing an unconditional get");
        this.get(resourceName, destination);
        return true;
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        if (this.authenticationInfo == null) {
            this.authenticationInfo = new AuthenticationInfo();
        }
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, source);
        if (!source.exists()) {
            throw new ResourceDoesNotExistException("Specified source file does not exist: " + source);
        }
        this.putMkdirRemote(destination);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.firePutStarted(resource, source);
        this.executeCopyCommand(resource, source, true, new String[0]);
        this.postProcessListeners(resource, source, 6);
        this.putSetPermissionRemote(resource, destination);
        this.firePutCompleted(resource, source);
    }

    @Override
    public boolean supportsDirectoryCopy() {
        return ExternalWagon.super.supportsDirectoryCopy();
    }

    protected abstract void putMkdirRemote(String var1) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException;

    protected abstract void putSetPermissionRemote(Resource var1, String var2) throws TransferFailedException;

    static String normalize(String resourceName) {
        return StringUtils.replace((String)resourceName, (String)"\\", (String)"/");
    }

    static String normalizeResource(Resource resource) {
        return AbstractExternalWagon.normalize(resource.getName());
    }

    static String prefixSlash(String str) {
        return str == null || str.startsWith("/") ? str : "/" + str;
    }

    static String suffixSlash(String str) {
        return str == null || str.endsWith("/") ? str : str + "/";
    }
}

