/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.util.List;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.rsync.external.AbstractExternalWagon;
import org.apache.maven.wagon.providers.rsync.external.SshCommandExecutor;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;

public abstract class AbstractSshWagon
extends AbstractExternalWagon
implements SshCommandExecutor {
    private ScpHelper sshTool = new ScpHelper((CommandExecutor)this);

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.getSshTool().getFileList(destinationDirectory, this.getRepository());
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.getSshTool().resourceExists(resourceName, this.getRepository());
    }

    @Override
    protected void putMkdirRemote(String destination) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        String dirPerms;
        Resource resource = new Resource(destination);
        String basedir = this.getRepository().getBasedir();
        String resourceName = AbstractExternalWagon.normalize(destination);
        String dir = PathUtils.dirname((String)resourceName);
        dir = AbstractExternalWagon.normalize(dir);
        String umaskCmd = null;
        if (this.getRepository().getPermissions() != null && (dirPerms = this.getRepository().getPermissions().getDirectoryMode()) != null) {
            umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor((String)dirPerms);
        }
        String mkdirCmd = "mkdir -p " + basedir + "/" + dir + "\n";
        if (umaskCmd != null) {
            mkdirCmd = umaskCmd + "; " + mkdirCmd;
        }
        try {
            this.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error executing command for transfer", (Throwable)e);
        }
    }

    @Override
    protected void putSetPermissionRemote(Resource resource, String destination) throws TransferFailedException {
        String basedir = this.getRepository().getBasedir();
        String resourceName = AbstractExternalWagon.normalize(destination);
        try {
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + basedir + "/" + resourceName + "\n", true);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.executeCommand("chmod -f " + permissions.getFileMode() + " " + basedir + "/" + resourceName + "\n", true);
            }
        }
        catch (CommandExecutionException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error executing command for transfer", (Throwable)e);
        }
    }

    public ScpHelper getSshTool() {
        return this.sshTool;
    }
}

