/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.rsync.external.AbstractExternalWagon;
import org.apache.maven.wagon.providers.rsync.external.RsyncListParser;
import org.apache.maven.wagon.providers.rsync.external.RsyncWagon;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class RsyncExternalWagon
extends AbstractExternalWagon
implements RsyncWagon {
    private String rsyncArgs = "--progress --compress --compress-level=6";
    private String rsyncExecutable = "rsync";

    public RsyncExternalWagon() {
        this.interactive = false;
    }

    @Override
    public String buildRemoteHost() {
        int port = this.getRepository().getPort() == -1 ? 873 : this.getRepository().getPort();
        return "rsync://" + super.buildRemoteHost() + ":" + port;
    }

    @Override
    public Commandline createBaseCommandLine(File privateKey, String ... options) {
        Commandline cl = RsyncWagon.super.createBaseCommandLine(options);
        if (options.length == 0) {
            cl.createArg().setValue("-a");
            cl.createArg().setValue("--no-R");
            cl.createArg().setValue("--no-implied-dirs");
        }
        return cl;
    }

    @Override
    public String getExecutable() {
        return this.getRsyncExecutable();
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException {
        return this.getFileList(destinationDirectory, false);
    }

    public boolean isInteractive() {
        return false;
    }

    @Override
    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        RsyncWagon.super.putDirectory(sourceDirectory, destinationDirectory);
    }

    @Override
    public void putMkdirRemote(String destination) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        RsyncWagon.super.putMkdirRemote(destination);
    }

    @Override
    public void putSetPermissionRemote(Resource resource, String destination) throws TransferFailedException {
        RsyncWagon.super.putSetPermissionRemote(resource, destination);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException {
        try {
            List<String> fileList = this.getFileList(PathUtils.dirname((String)resourceName), false);
            return fileList.contains(new File(resourceName).getName());
        }
        catch (ResourceDoesNotExistException ex) {
            return false;
        }
    }

    public void setInteractive(boolean interactive) {
    }

    private Streams executeCommand(Commandline cl, boolean ignoreFailures) throws CommandExecutionException {
        this.fireSessionDebug("Executing command: " + cl.toString());
        if (this.getAuthenticationInfo().getPassword() != null) {
            cl.addEnvironment("RSYNC_PASSWORD", this.getAuthenticationInfo().getPassword());
        }
        try {
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
            Streams streams = new Streams();
            streams.setOut(out.getOutput());
            streams.setErr(err.getOutput());
            this.fireSessionDebug(streams.getOut());
            this.fireSessionDebug(streams.getErr());
            if (exitCode != 0 && !ignoreFailures) {
                throw new CommandExecutionException("Exit code " + exitCode + " - " + err.getOutput());
            }
            return streams;
        }
        catch (CommandLineException e) {
            throw new CommandExecutionException("Error executing command line", (Throwable)e);
        }
    }

    private List<String> getFileList(String destinationDirectory, boolean recursive) throws TransferFailedException, ResourceDoesNotExistException {
        try {
            Commandline cl = RsyncWagon.super.createBaseCommandLine(new String[0]);
            if (recursive) {
                cl.createArg().setValue("--recursive");
            }
            String path = RsyncExternalWagon.getPath((String)this.getRepository().getBasedir(), (String)destinationDirectory);
            cl.createArg().setValue(this.buildRemoteHost() + StringUtils.replace((String)RsyncExternalWagon.suffixSlash(path), (String)" ", (String)"\\ "));
            Streams streams = this.executeCommand(cl, false);
            return new RsyncListParser().parseFiles(streams.getOut()).stream().filter(it -> !it.equals("./") && !it.equals("../")).collect(Collectors.toList());
        }
        catch (CommandExecutionException ex) {
            if (ex.getMessage().trim().endsWith("No such file or directory (2)") || ex.getMessage().contains("Exit code 23 ")) {
                throw new ResourceDoesNotExistException(ex.getMessage().trim(), (Throwable)ex);
            }
            throw new TransferFailedException("Error performing file listing.", (Throwable)ex);
        }
    }

    @Override
    public String getRsyncArgs() {
        return this.rsyncArgs;
    }

    public void setRsyncArgs(String rsyncArgs) {
        this.rsyncArgs = rsyncArgs;
    }

    @Override
    public String getRsyncExecutable() {
        return this.rsyncExecutable;
    }

    public void setRsyncExecutable(String rsyncExecutable) {
        this.rsyncExecutable = rsyncExecutable;
    }
}

