/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.wagon.TransferFailedException;

public class RsyncListParser {
    private static final Pattern PATTERN = Pattern.compile("^([d-]).+\\s+[0-9,]+\\s+[0-9/]+\\s+[0-9:]+\\s+(.+?)");

    public List<String> parseFiles(String rawLS) throws TransferFailedException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new StringReader(rawLS));
            String line = br.readLine();
            while (line != null) {
                Matcher m = PATTERN.matcher(line = line.trim());
                if (m.matches()) {
                    String type = m.group(1);
                    String name = m.group(2).replace("\\ ", " ");
                    ret.add("d".equals(type) ? name + "/" : name);
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Error parsing file listing.", (Throwable)e);
        }
        return ret;
    }
}

