/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import java.io.IOException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.rsync.external.AbstractSshWagon;
import org.apache.maven.wagon.providers.rsync.external.RsyncWagon;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.cli.Commandline;

public class RsyncSshExternalWagon
extends AbstractSshWagon
implements RsyncWagon {
    private String sshExecutable = "ssh";
    private String sshArgs;
    private String rsyncArgs = "--progress";
    private String rsyncExecutable = "rsync";

    public RsyncSshExternalWagon() {
        this.interactive = false;
    }

    @Override
    public String getExecutable() {
        return this.getRsyncExecutable();
    }

    @Override
    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        RsyncWagon.super.putDirectory(sourceDirectory, destinationDirectory);
    }

    @Override
    public void putMkdirRemote(String destination) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        RsyncWagon.super.putMkdirRemote(destination);
    }

    @Override
    public void putSetPermissionRemote(Resource resource, String destination) throws TransferFailedException {
        super.putSetPermissionRemote(resource, destination);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        super.connect(repository, authenticationInfo, proxyInfoProvider);
    }

    @Override
    public Commandline createBaseCommandLine(File privateKey, String ... options) {
        Commandline cl = RsyncWagon.super.createBaseCommandLine(options);
        cl.createArg().setValue("-e");
        cl.createArg().setValue(this.createSshCommandLine(privateKey));
        return cl;
    }

    public boolean isInteractive() {
        return false;
    }

    public void setInteractive(boolean interactive) {
    }

    private String createSshCommandLine(File privateKey) {
        String username;
        int port;
        StringBuilder ssh = new StringBuilder(this.getSshExecutable()).append(" ");
        if (privateKey != null) {
            ssh.append("-i ").append(privateKey.getAbsolutePath()).append(" ");
        }
        if (this.getSshArgs() != null) {
            ssh.append(this.getSshArgs()).append(" ");
        }
        if (this.getSshArgs() == null || !this.getSshArgs().contains(" StrictHostKeyChecking=")) {
            ssh.append("-o StrictHostKeyChecking=no ");
        }
        if (this.getSshArgs() == null || !this.getSshArgs().contains(" UserKnownHostsFile=")) {
            File knowHostsFile = new File("target/dummy_knowhost");
            if (knowHostsFile.exists()) {
                knowHostsFile.delete();
            }
            try {
                ssh.append("-o UserKnownHostsFile=").append(knowHostsFile.getCanonicalPath()).append(" ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n = port = this.getRepository().getPort() == -1 ? 22 : this.getRepository().getPort();
        if (port != 22) {
            ssh.append("-p ").append(port).append(" ");
        }
        String string = username = this.getRepository().getUsername() != null ? this.getRepository().getUsername() : this.getAuthenticationInfo().getUserName();
        if (username != null) {
            ssh.append("-l ").append(username).append(" ");
        }
        return ssh.toString().trim();
    }

    @Override
    public String getSshExecutable() {
        return this.sshExecutable;
    }

    public void setSshExecutable(String sshExecutable) {
        this.sshExecutable = sshExecutable;
    }

    @Override
    public String getSshArgs() {
        return this.sshArgs;
    }

    public void setSshArgs(String sshArgs) {
        this.sshArgs = sshArgs;
    }

    @Override
    public String getRsyncArgs() {
        return this.rsyncArgs;
    }

    public void setRsyncArgs(String rsyncArgs) {
        this.rsyncArgs = rsyncArgs;
    }

    @Override
    public String getRsyncExecutable() {
        return this.rsyncExecutable;
    }

    public void setRsyncExecutable(String rsyncExecutable) {
        this.rsyncExecutable = rsyncExecutable;
    }
}

