/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.rsync.external.AbstractExternalWagon;
import org.apache.maven.wagon.providers.rsync.external.ExternalWagon;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public interface RsyncWagon
extends ExternalWagon {
    default public Commandline createBaseCommandLine(String ... options) {
        Commandline cl = new Commandline();
        cl.setExecutable(this.getExecutable());
        if (this.getRsyncArgs() != null) {
            cl.createArg().setLine(this.getRsyncArgs());
        }
        for (String option : options) {
            cl.createArg().setValue(option);
        }
        return cl;
    }

    public String getRsyncArgs();

    public String getRsyncExecutable();

    default public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.createRemoteDirectory(destinationDirectory);
        String destDir = AbstractExternalWagon.normalize(destinationDirectory);
        try {
            this.executeCopyCommand(new Resource(destDir), new File(sourceDirectory.getCanonicalPath()), true, "-a", "-c", "-v");
        }
        catch (IOException ex) {
            throw new ResourceDoesNotExistException(ex.getMessage(), (Throwable)ex);
        }
    }

    default public void putMkdirRemote(String destination) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        this.createRemoteDirectory(PathUtils.dirname((String)destination));
    }

    default public void putSetPermissionRemote(Resource resource, String destination) throws TransferFailedException {
    }

    default public void createRemoteDirectory(String destinationDirectory) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        String remoteFile;
        File localFile;
        String repoPrefix = "target/rsync/repo";
        String repoDir = StringUtils.replace((String)this.getRepository().getBasedir(), (String)" ", (String)"\\ ");
        File repoTemplate = new File("target/rsync/repo" + AbstractExternalWagon.prefixSlash(repoDir));
        if (this.getRepository().getProtocol().contains("ssh")) {
            localFile = new File("target/rsync/repo");
            remoteFile = "/";
        } else {
            Path path = new File(repoDir).toPath();
            localFile = path.getNameCount() > 0 ? new File("target/rsync/repo/" + path.getName(0).toString()) : new File("target/rsync/repo");
            remoteFile = path.getNameCount() > 0 ? "/" + path.getName(0).toString() : repoDir;
        }
        repoTemplate.mkdirs();
        this.executeCopyCommand(new Resource("/"), remoteFile, localFile, true, "--recursive", "--dirs");
        String destPrefix = "target/rsync/dest";
        String destDir = AbstractExternalWagon.normalize(destinationDirectory);
        File destTemplate = new File("target/rsync/dest" + AbstractExternalWagon.prefixSlash(destDir));
        destTemplate.mkdirs();
        this.executeCopyCommand(new Resource("/"), new File("target/rsync/dest"), true, "--recursive", "--dirs");
    }
}

