/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.rsync.external.AbstractSshWagon;
import org.codehaus.plexus.util.cli.Commandline;

public class ScpExternalWagon
extends AbstractSshWagon {
    private String scpArgs;
    private String scpExecutable = "scp";
    private String sshArgs;
    private String sshExecutable = "ssh";

    @Override
    public String getExecutable() {
        return this.getScpExecutable();
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getSshTool().putDirectory((Wagon)this, sourceDirectory, destinationDirectory);
    }

    @Override
    protected Commandline createBaseCommandLine(File privateKey, String ... options) {
        int port;
        Commandline cl = this.createSshBaseCommandLine(this.getExecutable(), privateKey);
        int n = port = this.getRepository().getPort() == -1 ? 22 : this.getRepository().getPort();
        if (port != 22) {
            cl.createArg().setLine("-P " + port);
        }
        if (this.getScpArgs() != null) {
            cl.createArg().setLine(this.getScpArgs());
        }
        return cl;
    }

    public String getScpArgs() {
        return this.scpArgs;
    }

    public void setScpArgs(String scpArgs) {
        this.scpArgs = scpArgs;
    }

    public String getScpExecutable() {
        return this.scpExecutable;
    }

    public void setScpExecutable(String scpExecutable) {
        this.scpExecutable = scpExecutable;
    }

    @Override
    public String getSshArgs() {
        return this.sshArgs;
    }

    public void setSshArgs(String sshArgs) {
        this.sshArgs = sshArgs;
    }

    @Override
    public String getSshExecutable() {
        return this.sshExecutable;
    }

    public void setSshExecutable(String sshExecutable) {
        this.sshExecutable = sshExecutable;
    }
}

