/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionEventSupport;
import org.apache.maven.wagon.events.SessionListener;

public interface SessionEvents
extends Wagon {
    default public void addSessionListener(SessionListener listener) {
        this.getSessionEventSupport().addSessionListener(listener);
    }

    default public boolean hasSessionListener(SessionListener listener) {
        return this.getSessionEventSupport().hasSessionListener(listener);
    }

    default public void removeSessionListener(SessionListener listener) {
        this.getSessionEventSupport().removeSessionListener(listener);
    }

    public SessionEventSupport getSessionEventSupport();

    default public void fireSessionDisconnected() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 3);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionDisconnected(sessionEvent);
    }

    default public void fireSessionDisconnecting() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 2);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionDisconnecting(sessionEvent);
    }

    default public void fireSessionLoggedIn() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 7);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionLoggedIn(sessionEvent);
    }

    default public void fireSessionLoggedOff() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 8);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionLoggedOff(sessionEvent);
    }

    default public void fireSessionOpened() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 6);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionOpened(sessionEvent);
    }

    default public void fireSessionOpening() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 5);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionOpening(sessionEvent);
    }

    default public void fireSessionConnectionRefused() {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, 4);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionConnectionRefused(sessionEvent);
    }

    default public void fireSessionError(Exception exception) {
        long timestamp = System.currentTimeMillis();
        SessionEvent sessionEvent = new SessionEvent((Wagon)this, exception);
        sessionEvent.setTimestamp(timestamp);
        this.getSessionEventSupport().fireSessionError(sessionEvent);
    }

    default public void fireSessionDebug(String message) {
        this.getSessionEventSupport().fireDebug(message);
    }
}

