/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.rsync.external.WagonHasAuthenticationInfo;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public interface SshCommandExecutor
extends CommandExecutor,
WagonHasAuthenticationInfo {
    public static final int SSH_FATAL_EXIT_CODE = 255;

    public String getSshExecutable();

    public String getSshArgs();

    public void fireTransferDebug(String var1);

    public void fireSessionDebug(String var1);

    default public void executeCommand(String command) throws CommandExecutionException {
        this.fireTransferDebug("Executing command: " + command);
        this.executeCommand(command, false);
    }

    default public Streams executeCommand(String command, boolean ignoreFailures) throws CommandExecutionException {
        int port;
        File privateKey;
        try {
            privateKey = ScpHelper.getPrivateKey((AuthenticationInfo)this.getAuthenticationInfo());
        }
        catch (FileNotFoundException e) {
            throw new CommandExecutionException(e.getMessage(), (Throwable)e);
        }
        Commandline cl = this.createSshBaseCommandLine(this.getSshExecutable(), privateKey);
        if (this.getSshArgs() != null) {
            cl.createArg().setLine(this.getSshArgs());
        }
        String remoteHost = this.buildRemoteHost();
        cl.createArg().setValue(remoteHost);
        int n = port = this.getRepository().getPort() == -1 ? 22 : this.getRepository().getPort();
        if (port != 22) {
            cl.createArg().setLine("-p " + port);
        }
        cl.createArg().setValue(command);
        this.fireSessionDebug("Executing command: " + cl.toString());
        try {
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
            Streams streams = new Streams();
            streams.setOut(out.getOutput());
            streams.setErr(err.getOutput());
            this.fireSessionDebug(streams.getOut());
            this.fireSessionDebug(streams.getErr());
            if (!(exitCode == 0 || ignoreFailures && exitCode != 255)) {
                throw new CommandExecutionException("Exit code " + exitCode + " - " + err.getOutput());
            }
            return streams;
        }
        catch (CommandLineException e) {
            throw new CommandExecutionException("Error executing command line", (Throwable)e);
        }
    }

    default public Commandline createSshBaseCommandLine(String executable, File privateKey) {
        Commandline cl = new Commandline();
        cl.setExecutable(executable);
        if (privateKey != null) {
            cl.createArg().setValue("-i");
            cl.createArg().setFile(privateKey);
        }
        cl.createArg().setValue("-o");
        cl.createArg().setValue("BatchMode yes");
        if (this.getSshArgs() == null || !this.getSshArgs().contains(" StrictHostKeyChecking=")) {
            cl.createArg().setValue("-o");
            cl.createArg().setValue("StrictHostKeyChecking=no");
        }
        if (this.getSshArgs() == null || !this.getSshArgs().contains(" UserKnownHostsFile=")) {
            File knowHostsFile = new File("target/dummy_knowhost");
            if (knowHostsFile.exists()) {
                knowHostsFile.delete();
            }
            try {
                cl.createArg().setValue("-o");
                cl.createArg().setValue("UserKnownHostsFile=" + knowHostsFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cl;
    }
}

