/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.rsync.external;

import java.io.File;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferEventSupport;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;

public interface TransferEvents
extends Wagon {
    default public void addTransferListener(TransferListener listener) {
        this.getTransferEventSupport().addTransferListener(listener);
    }

    default public boolean hasTransferListener(TransferListener listener) {
        return this.getTransferEventSupport().hasTransferListener(listener);
    }

    default public void removeTransferListener(TransferListener listener) {
        this.getTransferEventSupport().removeTransferListener(listener);
    }

    public TransferEventSupport getTransferEventSupport();

    default public void fireTransferProgress(TransferEvent transferEvent, byte[] buffer, int n) {
        this.getTransferEventSupport().fireTransferProgress(transferEvent, buffer, n);
    }

    default public void fireGetCompleted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 2, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.getTransferEventSupport().fireTransferCompleted(transferEvent);
    }

    default public void fireGetStarted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 1, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.getTransferEventSupport().fireTransferStarted(transferEvent);
    }

    default public void fireGetInitiated(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 0, 5);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.getTransferEventSupport().fireTransferInitiated(transferEvent);
    }

    default public void firePutInitiated(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 0, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.getTransferEventSupport().fireTransferInitiated(transferEvent);
    }

    default public void firePutCompleted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 2, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.getTransferEventSupport().fireTransferCompleted(transferEvent);
    }

    default public void firePutStarted(Resource resource, File localFile) {
        long timestamp = System.currentTimeMillis();
        TransferEvent transferEvent = new TransferEvent((Wagon)this, resource, 1, 6);
        transferEvent.setTimestamp(timestamp);
        transferEvent.setLocalFile(localFile);
        this.getTransferEventSupport().fireTransferStarted(transferEvent);
    }

    default public void fireTransferDebug(String message) {
        this.getTransferEventSupport().fireDebug(message);
    }
}

