/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.logging;

import java.lang.reflect.Constructor;
import top.isopen.commons.logging.BaseLog;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogException;
import top.isopen.commons.logging.commons.JakartaCommonsLoggingImpl;
import top.isopen.commons.logging.jdk14.Jdk14LoggingImpl;
import top.isopen.commons.logging.log4j2.Log4j2Impl;
import top.isopen.commons.logging.nologging.NoLoggingImpl;
import top.isopen.commons.logging.slf4j.Slf4jImpl;
import top.isopen.commons.logging.stdout.StdOutImpl;

public class LogFactory {
    public static final String MARKER = "MYBATIS";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t);
        }
    }

    public static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized void useCommonsLogging() {
        LogFactory.setImplementation(JakartaCommonsLoggingImpl.class);
    }

    public static synchronized void useCustomLogging(Class<? extends BaseLog> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static synchronized void useJdkLogging() {
        LogFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    public static synchronized void useLog4J2Logging() {
        LogFactory.setImplementation(Log4j2Impl.class);
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jImpl.class);
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation(StdOutImpl.class);
    }

    private static void setImplementation(Class<? extends Log> implementation) {
        try {
            Constructor<? extends Log> candidate = implementation.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implementation + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(LogFactory::useSlf4jLogging);
        LogFactory.tryImplementation(LogFactory::useCommonsLogging);
        LogFactory.tryImplementation(LogFactory::useLog4J2Logging);
        LogFactory.tryImplementation(LogFactory::useJdkLogging);
        LogFactory.tryImplementation(LogFactory::useStdOutLogging);
        LogFactory.tryImplementation(LogFactory::useNoLogging);
    }
}

