/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.logging;

import java.util.HashSet;
import java.util.Set;
import top.isopen.commons.logging.FormattedTuple;

public final class MessageFormatter {
    private static final String DELIMITER = "{}";
    private static final char DELIMITER_START = '{';
    private static final char DELIMITER_STOP = '}';
    private static final char ESCAPED_CHAR = '\\';

    public static FormattedTuple format(String pattern, Object[] argsArray) {
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argsArray);
        Object[] args = argsArray;
        if (throwableCandidate != null) {
            args = MessageFormatter.trimmedCopy(argsArray);
        }
        return MessageFormatter.format(pattern, args, throwableCandidate);
    }

    public static FormattedTuple format(String pattern, Object[] args, Throwable throwable) {
        if (pattern == null) {
            return new FormattedTuple(null, args, throwable);
        }
        if (args == null) {
            return new FormattedTuple(pattern);
        }
        int i = 0;
        int j = 0;
        StringBuilder builder = new StringBuilder();
        for (int k = 0; k < args.length; ++k) {
            j = pattern.indexOf(DELIMITER, i);
            if (j == -1) {
                if (i == 0) {
                    return new FormattedTuple(pattern, args, throwable);
                }
                builder.append(pattern, i, pattern.length());
                return new FormattedTuple(builder.toString(), args, throwable);
            }
            if (MessageFormatter.isEscapedDelimiter(pattern, j)) {
                if (!MessageFormatter.isDoubleEscaped(pattern, j)) {
                    --k;
                    builder.append(pattern, i, j - 1);
                    builder.append('{');
                    i = j + 1;
                    continue;
                }
                builder.append(pattern, i, j - 1);
                MessageFormatter.deepAppendParameter(builder, args[k], new HashSet<Object[]>());
                i = j + 2;
                continue;
            }
            builder.append(pattern, i, j);
            MessageFormatter.deepAppendParameter(builder, args[k], new HashSet<Object[]>());
            i = j + 2;
        }
        builder.append(pattern, i, pattern.length());
        return new FormattedTuple(builder.toString(), args, throwable);
    }

    public static String formatToString(String pattern, Object object) {
        return MessageFormatter.formatToString(pattern, new Object[]{object});
    }

    public static String formatToString(String pattern, Object ... objects) {
        return MessageFormatter.format(pattern, objects, null).getMessage();
    }

    public static Throwable getThrowableCandidate(Object[] argsArray) {
        if (argsArray == null || argsArray.length == 0) {
            return null;
        }
        Object object = argsArray[argsArray.length - 1];
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    private static void booleanArrayAppend(StringBuilder builder, boolean[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static void byteArrayAppend(StringBuilder builder, byte[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static void charArrayAppend(StringBuilder builder, char[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static void deepAppendParameter(StringBuilder builder, Object param, Set<Object[]> seenSet) {
        if (param == null) {
            builder.append("null");
            return;
        }
        if (!param.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(builder, param);
        } else if (param instanceof byte[]) {
            MessageFormatter.byteArrayAppend(builder, (byte[])param);
        } else if (param instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(builder, (boolean[])param);
        } else if (param instanceof char[]) {
            MessageFormatter.charArrayAppend(builder, (char[])param);
        } else if (param instanceof short[]) {
            MessageFormatter.shortArrayAppend(builder, (short[])param);
        } else if (param instanceof int[]) {
            MessageFormatter.intArrayAppend(builder, (int[])param);
        } else if (param instanceof long[]) {
            MessageFormatter.longArrayAppend(builder, (long[])param);
        } else if (param instanceof float[]) {
            MessageFormatter.floatArrayAppend(builder, (float[])param);
        } else if (param instanceof double[]) {
            MessageFormatter.doubleArrayAppend(builder, (double[])param);
        } else {
            MessageFormatter.objectArrayAppend(builder, (Object[])param, seenSet);
        }
    }

    private static void doubleArrayAppend(StringBuilder builder, double[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static void floatArrayAppend(StringBuilder builder, float[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static void intArrayAppend(StringBuilder builder, int[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static boolean isDoubleEscaped(String pattern, int delimiterStartIndex) {
        return delimiterStartIndex >= 2 && pattern.charAt(delimiterStartIndex - 2) == '\\';
    }

    private static boolean isEscapedDelimiter(String pattern, int delimiterStartIndex) {
        if (delimiterStartIndex == 0) {
            return false;
        }
        return pattern.charAt(delimiterStartIndex - 1) == '\\';
    }

    private static void longArrayAppend(StringBuilder builder, long[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static void objectArrayAppend(StringBuilder builder, Object[] param, Set<Object[]> seenSet) {
        builder.append('[');
        if (!seenSet.contains(param)) {
            seenSet.add(param);
            int length = param.length;
            for (int i = 0; i < length; ++i) {
                MessageFormatter.deepAppendParameter(builder, param[i], seenSet);
                if (i == length - 1) continue;
                builder.append(',').append(' ');
            }
            seenSet.remove(param);
        } else {
            builder.append("...");
        }
        builder.append(']');
    }

    private static void safeObjectAppend(StringBuilder builder, Object param) {
        try {
            builder.append(param.toString());
        }
        catch (Throwable throwable) {
            builder.append("[FAILED toString()]");
        }
    }

    private static void shortArrayAppend(StringBuilder builder, short[] param) {
        builder.append('[');
        int length = param.length;
        for (int i = 0; i < length; ++i) {
            builder.append(param[i]);
            if (i == length - 1) continue;
            builder.append(',').append(' ');
        }
        builder.append(']');
    }

    private static Object[] trimmedCopy(Object[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalStateException("nonsensical empty or null argument array");
        }
        Object[] trimmed = new Object[array.length - 1];
        if (trimmed.length > 0) {
            System.arraycopy(array, 0, trimmed, 0, trimmed.length);
        }
        return trimmed;
    }
}

