/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.types;

import java.io.Serializable;
import top.isopen.commons.springboot.enums.BaseErrorEnum;
import top.isopen.commons.springboot.support.SFunction;
import top.isopen.commons.springboot.util.FieldUtil;
import top.isopen.commons.springboot.util.NameUtil;

public class OrderBy
implements Serializable {
    private static final long serialVersionUID = 2006033976690108451L;
    private Column column;
    private boolean asc;

    public static OrderBy asc(String column) {
        return ((OrderByBuilder)((OrderByBuilder)OrderBy.builder().column(new Column(column))).asc(true)).build();
    }

    public static <T> OrderBy asc(SFunction<T, ?> func) {
        return ((OrderByBuilder)((OrderByBuilder)OrderBy.builder().column(new Column(FieldUtil.resolveName(func)))).asc(true)).build();
    }

    public static OrderBy desc(String column) {
        return ((OrderByBuilder)((OrderByBuilder)OrderBy.builder().column(new Column(column))).asc(false)).build();
    }

    public static <T> OrderBy desc(SFunction<T, ?> func) {
        return ((OrderByBuilder)((OrderByBuilder)OrderBy.builder().column(new Column(FieldUtil.resolveName(func)))).asc(false)).build();
    }

    protected OrderBy(OrderByBuilder<?, ?> b) {
        this.column = ((OrderByBuilder)b).column;
        this.asc = ((OrderByBuilder)b).asc;
    }

    public static OrderByBuilder<?, ?> builder() {
        return new OrderByBuilderImpl();
    }

    public OrderByBuilder<?, ?> toBuilder() {
        return new OrderByBuilderImpl().$fillValuesFrom(this);
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsc() != other.isAsc()) {
            return false;
        }
        Column this$column = this.getColumn();
        Column other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !((Object)this$column).equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderBy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsc() ? 79 : 97);
        Column $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        return result;
    }

    public String toString() {
        return "OrderBy(column=" + this.getColumn() + ", asc=" + this.isAsc() + ")";
    }

    public OrderBy() {
    }

    private static final class OrderByBuilderImpl
    extends OrderByBuilder<OrderBy, OrderByBuilderImpl> {
        private OrderByBuilderImpl() {
        }

        @Override
        protected OrderByBuilderImpl self() {
            return this;
        }

        @Override
        public OrderBy build() {
            return new OrderBy(this);
        }
    }

    public static abstract class OrderByBuilder<C extends OrderBy, B extends OrderByBuilder<C, B>> {
        private Column column;
        private boolean asc;

        protected B $fillValuesFrom(C instance) {
            OrderByBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(OrderBy instance, OrderByBuilder<?, ?> b) {
            b.column(instance.column);
            b.asc(instance.asc);
        }

        protected abstract B self();

        public abstract C build();

        public B column(Column column) {
            this.column = column;
            return this.self();
        }

        public B asc(boolean asc) {
            this.asc = asc;
            return this.self();
        }

        public String toString() {
            return "OrderBy.OrderByBuilder(column=" + this.column + ", asc=" + this.asc + ")";
        }
    }

    public static final class Column {
        private final String value;

        public Column(String value) {
            if (value == null || value.length() == 0) {
                BaseErrorEnum.INVALID_ORDER_BY_COLUMN_ERROR.throwException();
            }
            this.value = NameUtil.humpToUnderline(value);
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "OrderBy.Column(value=" + this.getValue() + ")";
        }
    }
}

