/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.helper;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.enums.BaseErrorEnum;

public class RedisHelper {
    private static final Log log = LogFactory.getLog(RedisHelper.class);
    private static StringRedisTemplate redisTemplate;

    public RedisHelper(StringRedisTemplate redisTemplate) {
        RedisHelper.redisTemplate = redisTemplate;
    }

    public static class Helper {
        public static final String DEFAULT_SYMBOL = ":";

        public static String join(String ... args) {
            return Helper.joinBySymbol(DEFAULT_SYMBOL, args);
        }

        public static String joinBySymbol(String symbol, String ... args) {
            if (symbol == null || symbol.trim().length() == 0) {
                throw new RuntimeException(" symbol must not be empty!");
            }
            if (args == null || args.length == 0) {
                throw new RuntimeException(" args must not be empty!");
            }
            StringBuilder sb = new StringBuilder(16);
            for (String arg : args) {
                sb.append(arg).append(symbol);
            }
            sb.replace(sb.length() - symbol.length(), sb.length(), "");
            return sb.toString();
        }
    }

    public static class LockOps {
        public static final long DEFAULT_LOCK_TIMEOUT = 3L;
        public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
        private static final String RELEASE_LOCK_LUA = "if redis.call('get',KEYS[1]) == ARGV[1] then     return redis.call('del',KEYS[1]) else     return 0 end ";

        public static boolean getLock(String key, String value) {
            return LockOps.getLock(key, value, 3L, DEFAULT_TIMEOUT_UNIT);
        }

        public static boolean getLockUntilTimeout(String key, String value, long retryTimeoutLimit) {
            return LockOps.getLockUntilTimeout(key, value, 3L, DEFAULT_TIMEOUT_UNIT, retryTimeoutLimit);
        }

        public static boolean getLockUntilTimeout(String key, String value, long timeout, TimeUnit unit, long retryTimeoutLimit) {
            long startTime;
            log.info("getLockUntilTimeout(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}, retryTimeoutLimit -> {}ms", new Object[]{key, value, timeout, unit, retryTimeoutLimit});
            long now = startTime = Instant.now().toEpochMilli();
            do {
                try {
                    boolean alreadyGotLock = LockOps.getLock(key, value, timeout, unit, false);
                    if (alreadyGotLock) {
                        log.info("getLockUntilTimeout(...) => consume time -> {}ms, result -> true", new Object[]{now - startTime});
                        return true;
                    }
                }
                catch (Exception e) {
                    log.warn("getLockUntilTimeout(...) => try to get lock failure! e.getMessage -> {}", new Object[]{e.getMessage()});
                }
            } while ((now = Instant.now().toEpochMilli()) < startTime + retryTimeoutLimit);
            log.info("getLockUntilTimeout(...) => consume time -> {}ms, result -> false", new Object[]{now - startTime});
            return false;
        }

        public static boolean getLock(String key, String value, long timeout, TimeUnit unit) {
            return LockOps.getLock(key, value, timeout, unit, true);
        }

        public static boolean getLock(String key, String value, long timeout, TimeUnit unit, boolean recordLog) {
            if (recordLog) {
                log.info("getLock(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}", new Object[]{key, value, timeout, unit});
            }
            Boolean result = (Boolean)redisTemplate.execute(connection -> connection.set(key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8), Expiration.seconds((long)unit.toSeconds(timeout)), RedisStringCommands.SetOption.SET_IF_ABSENT));
            if (recordLog) {
                log.info("getLock(...) => result -> {}", new Object[]{result});
            }
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static boolean releaseLock(String key, String value) {
            log.info("releaseLock(...) => key -> {}, lockValue -> {}", new Object[]{key, value});
            Boolean result = (Boolean)redisTemplate.execute(connection -> (Boolean)connection.eval(RELEASE_LOCK_LUA.getBytes(), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8)}));
            log.info("releaseLock(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }
    }

    public static class ZSetOps {
        public static boolean zAdd(String key, String item, double score) {
            log.info("zAdd(...) => key -> {}, item -> {}, score -> {}", new Object[]{key, item, score});
            Boolean result = redisTemplate.opsForZSet().add((Object)key, (Object)item, score);
            log.info("zAdd(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static long zAdd(String key, Set<ZSetOperations.TypedTuple<String>> entries) {
            log.info("zAdd(...) => key -> {}, entries -> {}", new Object[]{key, JSON.toJSONString(entries)});
            Long count = redisTemplate.opsForZSet().add((Object)key, entries);
            log.info("zAdd(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static long zRemove(String key, Object ... items) {
            log.info("zRemove(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long count = redisTemplate.opsForZSet().remove((Object)key, items);
            log.info("zRemove(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static long zRemoveRange(String key, long startRange, long endRange) {
            log.info("zRemoveRange(...) => key -> {}, startRange -> {}, endRange -> {}", new Object[]{key, startRange, endRange});
            Long count = redisTemplate.opsForZSet().removeRange((Object)key, startRange, endRange);
            log.info("zRemoveRange(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static long zRemoveRangeByScore(String key, double minScore, double maxScore) {
            log.info("zRemoveRangeByScore(...) => key -> {}, startIndex -> {}, startIndex -> {}", new Object[]{key, minScore, maxScore});
            Long count = redisTemplate.opsForZSet().removeRangeByScore((Object)key, minScore, maxScore);
            log.info("zRemoveRangeByScore(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static double zIncrementScore(String key, String item, double delta) {
            log.info("zIncrementScore(...) => key -> {}, item -> {}, delta -> {}", new Object[]{key, item, delta});
            Double scoreValue = redisTemplate.opsForZSet().incrementScore((Object)key, (Object)item, delta);
            log.info("zIncrementScore(...) => scoreValue -> {}", new Object[]{scoreValue});
            if (scoreValue == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return scoreValue;
        }

        public static long zRank(String key, Object item) {
            log.info("zRank(...) => key -> {}, item -> {}", new Object[]{key, item});
            Long rank = redisTemplate.opsForZSet().rank((Object)key, item);
            log.info("zRank(...) => rank -> {}", new Object[]{rank});
            if (rank == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return rank;
        }

        public static long zReverseRank(String key, Object item) {
            log.info("zReverseRank(...) => key -> {}, item -> {}", new Object[]{key, item});
            Long reverseRank = redisTemplate.opsForZSet().reverseRank((Object)key, item);
            log.info("zReverseRank(...) => reverseRank -> {}", new Object[]{reverseRank});
            if (reverseRank == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return reverseRank;
        }

        public static Set<String> zRange(String key, long start, long end) {
            log.info("zRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            Set result = redisTemplate.opsForZSet().range((Object)key, start, end);
            log.info("zRange(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static Set<String> zWholeZSetItem(String key) {
            log.info("zWholeZSetItem(...) => key -> {}", new Object[]{key});
            Set result = redisTemplate.opsForZSet().range((Object)key, 0L, -1L);
            log.info("zWholeZSetItem(...) =>result -> {}", new Object[]{result});
            return result;
        }

        public static Set<ZSetOperations.TypedTuple<String>> zRangeWithScores(String key, long start, long end) {
            log.info("zRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            Set entries = redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
            log.info("zRangeWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
            return entries;
        }

        public static Set<ZSetOperations.TypedTuple<String>> zWholeZSetEntry(String key) {
            log.info("zWholeZSetEntry(...) => key -> {}", new Object[]{key});
            Set entries = redisTemplate.opsForZSet().rangeWithScores((Object)key, 0L, -1L);
            log.info("zWholeZSetEntry(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
            return entries;
        }

        public static Set<String> zRangeByScore(String key, double minScore, double maxScore) {
            log.info("zRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            Set items = redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore);
            log.info("zRangeByScore(...) => items -> {}", new Object[]{items});
            return items;
        }

        public static Set<String> zRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
            log.info("zRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
            Set items = redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore, offset, count);
            log.info("zRangeByScore(...) => items -> {}", new Object[]{items});
            return items;
        }

        public static Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double minScore, double maxScore) {
            log.info("zRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            Set entries = redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore);
            log.info("zRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
            return entries;
        }

        public static Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double minScore, double maxScore, long offset, long count) {
            log.info("zRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
            Set entries = redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore, offset, count);
            log.info("zRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
            return entries;
        }

        public static Set<String> zReverseRange(String key, long start, long end) {
            log.info("zReverseRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            Set entries = redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
            log.info("zReverseRange(...) => entries -> {}", new Object[]{entries});
            return entries;
        }

        public static Set<ZSetOperations.TypedTuple<String>> zReverseRangeWithScores(String key, long start, long end) {
            log.info("zReverseRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            Set entries = redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
            log.info("zReverseRangeWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
            return entries;
        }

        public static Set<String> zReverseRangeByScore(String key, double minScore, double maxScore) {
            log.info("zReverseRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            Set items = redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore);
            log.info("zReverseRangeByScore(...) => items -> {}", new Object[]{items});
            return items;
        }

        public static Set<ZSetOperations.TypedTuple<String>> zReverseRangeByScoreWithScores(String key, double minScore, double maxScore) {
            log.info("zReverseRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            Set entries = redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, minScore, maxScore);
            log.info("zReverseRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
            return entries;
        }

        public static Set<String> zReverseRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
            log.info("zReverseRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
            Set items = redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore, offset, count);
            log.info("items -> {}", new Object[]{items});
            return items;
        }

        public static long zCount(String key, double minScore, double maxScore) {
            log.info("zCount(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            Long count = redisTemplate.opsForZSet().count((Object)key, minScore, maxScore);
            log.info("zCount(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static long zSize(String key) {
            log.info("zSize(...) => key -> {}", new Object[]{key});
            Long size = redisTemplate.opsForZSet().size((Object)key);
            log.info("zSize(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long zZCard(String key) {
            log.info("zZCard(...) => key -> {}", new Object[]{key});
            Long size = redisTemplate.opsForZSet().zCard((Object)key);
            log.info("zZCard(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static double zScore(String key, Object item) {
            log.info("zScore(...) => key -> {}, item -> {}", new Object[]{key, item});
            Double score = redisTemplate.opsForZSet().score((Object)key, item);
            log.info("zScore(...) => score -> {}", new Object[]{score});
            if (score == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return score;
        }

        public static long zUnionAndStore(String key, String otherKey, String storeKey) {
            log.info("zUnionAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            Long size = redisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            log.info("zUnionAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long zUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
            log.info("zUnionAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            Long size = redisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
            log.info("zUnionAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long zIntersectAndStore(String key, String otherKey, String storeKey) {
            log.info("zIntersectAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            Long size = redisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            log.info("zIntersectAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long zIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
            log.info("zIntersectAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            Long size = redisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
            log.info("zIntersectAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }
    }

    public static class SetOps {
        public static long sAdd(String key, String ... items) {
            log.info("sAdd(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long count = redisTemplate.opsForSet().add((Object)key, (Object[])items);
            log.info("sAdd(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static long sRemove(String key, Object ... items) {
            log.info("sRemove(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long count = redisTemplate.opsForSet().remove((Object)key, items);
            log.info("sRemove(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static String sPop(String key) {
            log.info("sPop(...) => key -> {}", new Object[]{key});
            String popItem = (String)redisTemplate.opsForSet().pop((Object)key);
            log.info("sPop(...) => popItem -> {}", new Object[]{popItem});
            return popItem;
        }

        public static boolean sMove(String sourceKey, String item, String destinationKey) {
            Boolean result = redisTemplate.opsForSet().move((Object)sourceKey, (Object)item, (Object)destinationKey);
            log.info("sMove(...) => sourceKey -> {}, destinationKey -> {}, item -> {}", new Object[]{sourceKey, destinationKey, item});
            log.info("sMove(...) =>  result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static long sSize(String key) {
            log.info("sSize(...) => key -> {}", new Object[]{key});
            Long size = redisTemplate.opsForSet().size((Object)key);
            log.info("sSize(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static boolean sIsMember(String key, Object item) {
            log.info("sSize(...) => key -> {}, size -> {}", new Object[]{key, item});
            Boolean result = redisTemplate.opsForSet().isMember((Object)key, item);
            log.info("sSize(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static Set<String> sIntersect(String key, String otherKey) {
            log.info("sIntersect(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
            Set intersectResult = redisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
            log.info("sIntersect(...) => intersectResult -> {}", new Object[]{intersectResult});
            return intersectResult;
        }

        public static Set<String> sIntersect(String key, Collection<String> otherKeys) {
            log.info("sIntersect(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
            Set intersectResult = redisTemplate.opsForSet().intersect((Object)key, otherKeys);
            log.info("sIntersect(...) => intersectResult -> {}", new Object[]{intersectResult});
            return intersectResult;
        }

        public static long sIntersectAndStore(String key, String otherKey, String storeKey) {
            log.info("sIntersectAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            Long size = redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            log.info("sIntersectAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long sIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
            log.info("sIntersectAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            Long size = redisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
            log.info("sIntersectAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static Set<String> sUnion(String key, String otherKey) {
            log.info("sUnion(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
            Set unionResult = redisTemplate.opsForSet().union((Object)key, (Object)otherKey);
            log.info("sUnion(...) => unionResult -> {}", new Object[]{unionResult});
            return unionResult;
        }

        public static Set<String> sUnion(String key, Collection<String> otherKeys) {
            log.info("sUnion(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
            Set unionResult = redisTemplate.opsForSet().union((Object)key, otherKeys);
            log.info("sUnion(...) => unionResult -> {}", new Object[]{unionResult});
            return unionResult;
        }

        public static long sUnionAndStore(String key, String otherKey, String storeKey) {
            log.info("sUnionAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            Long size = redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            log.info("sUnionAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long sUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
            log.info("sUnionAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            Long size = redisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
            log.info("sUnionAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static Set<String> sDifference(String key, String otherKey) {
            log.info("sDifference(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
            Set differenceResult = redisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
            log.info("sDifference(...) => differenceResult -> {}", new Object[]{differenceResult});
            return differenceResult;
        }

        public static Set<String> sDifference(String key, Collection<String> otherKeys) {
            log.info("sDifference(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
            Set differenceResult = redisTemplate.opsForSet().difference((Object)key, otherKeys);
            log.info("sDifference(...) => differenceResult -> {}", new Object[]{differenceResult});
            return differenceResult;
        }

        public static long sDifferenceAndStore(String key, String otherKey, String storeKey) {
            log.info("sDifferenceAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            Long size = redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            log.info("sDifferenceAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long sDifferenceAndStore(String key, Collection<String> otherKeys, String storeKey) {
            log.info("sDifferenceAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            Long size = redisTemplate.opsForSet().differenceAndStore((Object)key, otherKeys, (Object)storeKey);
            log.info("sDifferenceAndStore(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static Set<String> sMembers(String key) {
            log.info("sMembers(...) => key -> {}", new Object[]{key});
            Set members = redisTemplate.opsForSet().members((Object)key);
            log.info("sMembers(...) => members -> {}", new Object[]{members});
            return members;
        }

        public static String sRandomMember(String key) {
            log.info("sRandomMember(...) => key -> {}", new Object[]{key});
            String randomItem = (String)redisTemplate.opsForSet().randomMember((Object)key);
            log.info("sRandomMember(...) => randomItem -> {}", new Object[]{randomItem});
            return randomItem;
        }

        public static List<String> sRandomMembers(String key, long count) {
            log.info("sRandomMembers(...) => key -> {}, count -> {}", new Object[]{key, count});
            List randomItems = redisTemplate.opsForSet().randomMembers((Object)key, count);
            log.info("sRandomMembers(...) => randomItems -> {}", new Object[]{randomItems});
            return randomItems;
        }

        public static Set<String> sDistinctRandomMembers(String key, long count) {
            log.info("sDistinctRandomMembers(...) => key -> {}, count -> {}", new Object[]{key, count});
            Set distinctRandomItems = redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
            log.info("sDistinctRandomMembers(...) => distinctRandomItems -> {}", new Object[]{distinctRandomItems});
            return distinctRandomItems;
        }

        public static Cursor<String> sScan(String key, ScanOptions options) {
            log.info("sScan(...) => key -> {}, options -> {}", new Object[]{key, JSON.toJSONString((Object)options)});
            Cursor cursor = redisTemplate.opsForSet().scan((Object)key, options);
            log.info("sScan(...) => cursor -> {}", new Object[]{JSON.toJSONString((Object)cursor)});
            return cursor;
        }
    }

    public static class ListOps {
        public static long lLeftPush(String key, String item) {
            log.info("lLeftPush(...) => key -> {}, item -> {}", new Object[]{key, item});
            Long size = redisTemplate.opsForList().leftPush((Object)key, (Object)item);
            log.info("lLeftPush(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lLeftPushAll(String key, String ... items) {
            log.info("lLeftPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long size = redisTemplate.opsForList().leftPushAll((Object)key, (Object[])items);
            log.info("lLeftPushAll(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lLeftPushAll(String key, Collection<String> items) {
            log.info("lLeftPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long size = redisTemplate.opsForList().leftPushAll((Object)key, items);
            log.info("lLeftPushAll(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lLeftPushIfPresent(String key, String item) {
            log.info("lLeftPushIfPresent(...) => key -> {}, item -> {}", new Object[]{key, item});
            Long size = redisTemplate.opsForList().leftPushIfPresent((Object)key, (Object)item);
            log.info("lLeftPushIfPresent(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lLeftPush(String key, String pivot, String item) {
            log.info("lLeftPush(...) => key -> {}, pivot -> {}, item -> {}", new Object[]{key, pivot, item});
            Long size = redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)item);
            log.info("lLeftPush(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lRightPush(String key, String item) {
            log.info("lRightPush(...) => key -> {}, item -> {}", new Object[]{key, item});
            Long size = redisTemplate.opsForList().rightPush((Object)key, (Object)item);
            log.info("lRightPush(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lRightPushAll(String key, String ... items) {
            log.info("lRightPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long size = redisTemplate.opsForList().rightPushAll((Object)key, (Object[])items);
            log.info("lRightPushAll(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lRightPushAll(String key, Collection<String> items) {
            log.info("lRightPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            Long size = redisTemplate.opsForList().rightPushAll((Object)key, items);
            log.info("lRightPushAll(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lRightPushIfPresent(String key, String item) {
            log.info("lRightPushIfPresent(...) => key -> {}, item -> {}", new Object[]{key, item});
            Long size = redisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)item);
            log.info("lRightPushIfPresent(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lRightPush(String key, String pivot, String item) {
            log.info("lLeftPush(...) => key -> {}, pivot -> {}, item -> {}", new Object[]{key, pivot, item});
            Long size = redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, (Object)item);
            log.info("lLeftPush(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static String lLeftPop(String key) {
            log.info("lLeftPop(...) => key -> {}", new Object[]{key});
            String item = (String)redisTemplate.opsForList().leftPop((Object)key);
            log.info("lLeftPop(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static String lLeftPop(String key, long timeout, TimeUnit unit) {
            log.info("lLeftPop(...) => key -> {}, timeout -> {}, unit -> {}", new Object[]{key, timeout, unit});
            String item = (String)redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
            log.info("lLeftPop(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static String lRightPop(String key) {
            log.info("lRightPop(...) => key -> {}", new Object[]{key});
            String item = (String)redisTemplate.opsForList().rightPop((Object)key);
            log.info("lRightPop(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static String lRightPop(String key, long timeout, TimeUnit unit) {
            log.info("lRightPop(...) => key -> {}, timeout -> {}, unit -> {}", new Object[]{key, timeout, unit});
            String item = (String)redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
            log.info("lRightPop(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static String lRightPopAndLeftPush(String sourceKey, String destinationKey) {
            log.info("lRightPopAndLeftPush(...) => sourceKey -> {}, destinationKey -> {}", new Object[]{sourceKey, destinationKey});
            String item = (String)redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
            log.info("lRightPopAndLeftPush(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static String lRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
            log.info("lRightPopAndLeftPush(...) => sourceKey -> {}, destinationKey -> {}, timeout -> {}, unit -> {}", new Object[]{sourceKey, destinationKey, timeout, unit});
            String item = (String)redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
            log.info("lRightPopAndLeftPush(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static void lSet(String key, long index, String item) {
            log.info("lSet(...) => key -> {}, index -> {}, item -> {}", new Object[]{key, index, item});
            redisTemplate.opsForList().set((Object)key, index, (Object)item);
        }

        public static String lIndex(String key, long index) {
            log.info("lIndex(...) => key -> {}, index -> {}", new Object[]{key, index});
            String item = (String)redisTemplate.opsForList().index((Object)key, index);
            log.info("lIndex(...) => item -> {}", new Object[]{item});
            return item;
        }

        public static List<String> lRange(String key, long start, long end) {
            log.info("lRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            List result = redisTemplate.opsForList().range((Object)key, start, end);
            log.info("lRange(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static List<String> lWholeList(String key) {
            log.info("lWholeList(...) => key -> {}", new Object[]{key});
            List result = redisTemplate.opsForList().range((Object)key, 0L, -1L);
            log.info("lWholeList(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static long lSize(String key) {
            log.info("lSize(...) => key -> {}", new Object[]{key});
            Long size = redisTemplate.opsForList().size((Object)key);
            log.info("lSize(...) => size -> {}", new Object[]{size});
            if (size == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return size;
        }

        public static long lRemove(String key, long expectCount, String item) {
            log.info("lRemove(...) => key -> {}, expectCount -> {}, item -> {}", new Object[]{key, expectCount, item});
            Long actualCount = redisTemplate.opsForList().remove((Object)key, expectCount, (Object)item);
            log.info("lRemove(...) => actualCount -> {}", new Object[]{actualCount});
            if (actualCount == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return actualCount;
        }

        public static void lTrim(String key, long start, long end) {
            log.info("lTrim(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            redisTemplate.opsForList().trim((Object)key, start, end);
        }
    }

    public static class HashOps {
        public static void hPut(String key, String entryKey, String entryValue) {
            log.info("hPut(...) => key -> {}, entryKey -> {}, entryValue -> {}", new Object[]{key, entryKey, entryValue});
            redisTemplate.opsForHash().put((Object)key, (Object)entryKey, (Object)entryValue);
        }

        public static void hPutAll(String key, Map<String, String> maps) {
            log.info("hPutAll(...) => key -> {}, maps -> {}", new Object[]{key, maps});
            redisTemplate.opsForHash().putAll((Object)key, maps);
        }

        public static boolean hPutIfAbsent(String key, String entryKey, String entryValue) {
            log.info("hPutIfAbsent(...) => key -> {}, entryKey -> {}, entryValue -> {}", new Object[]{key, entryKey, entryValue});
            Boolean result = redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)entryKey, (Object)entryValue);
            log.info("hPutIfAbsent(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static Object hGet(String key, String entryKey) {
            log.info("hGet(...) => key -> {}, entryKey -> {}", new Object[]{key, entryKey});
            Object entryValue = redisTemplate.opsForHash().get((Object)key, (Object)entryKey);
            log.info("hGet(...) => entryValue -> {}", new Object[]{entryValue});
            return entryValue;
        }

        public static Map<Object, Object> hGetAll(String key) {
            log.info("hGetAll(...) => key -> {}", new Object[]{key});
            Map result = redisTemplate.opsForHash().entries((Object)key);
            log.info("hGetAll(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static List<Object> hMultiGet(String key, Collection<Object> entryKeys) {
            log.info("hMultiGet(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKeys});
            List entryValues = redisTemplate.opsForHash().multiGet((Object)key, entryKeys);
            log.info("hMultiGet(...) => entryValues -> {}", new Object[]{entryValues});
            return entryValues;
        }

        public static long hDelete(String key, Object ... entryKeys) {
            log.info("hDelete(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKeys});
            Long count = redisTemplate.opsForHash().delete((Object)key, entryKeys);
            log.info("hDelete(...) => count -> {}", new Object[]{count});
            return count;
        }

        public static boolean hExists(String key, String entryKey) {
            log.info("hDelete(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKey});
            Boolean exist = redisTemplate.opsForHash().hasKey((Object)key, (Object)entryKey);
            log.info("hDelete(...) => exist -> {}", new Object[]{exist});
            return exist;
        }

        public static long hIncrBy(String key, Object entryKey, long increment) {
            log.info("hIncrBy(...) => key -> {}, entryKey -> {}, increment -> {}", new Object[]{key, entryKey, increment});
            Long result = redisTemplate.opsForHash().increment((Object)key, entryKey, increment);
            log.info("hIncrBy(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static double hIncrByFloat(String key, Object entryKey, double increment) {
            log.info("hIncrByFloat(...) => key -> {}, entryKey -> {}, increment -> {}", new Object[]{key, entryKey, increment});
            Double result = redisTemplate.opsForHash().increment((Object)key, entryKey, increment);
            log.info("hIncrByFloat(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static Set<Object> hKeys(String key) {
            log.info("hKeys(...) => key -> {}", new Object[]{key});
            Set entryKeys = redisTemplate.opsForHash().keys((Object)key);
            log.info("hKeys(...) => entryKeys -> {}", new Object[]{entryKeys});
            return entryKeys;
        }

        public static List<Object> hValues(String key) {
            log.info("hValues(...) => key -> {}", new Object[]{key});
            List entryValues = redisTemplate.opsForHash().values((Object)key);
            log.info("hValues(...) => entryValues -> {}", new Object[]{entryValues});
            return entryValues;
        }

        public static long hSize(String key) {
            log.info("hSize(...) => key -> {}", new Object[]{key});
            Long count = redisTemplate.opsForHash().size((Object)key);
            log.info("hSize(...) => count -> {}", new Object[]{count});
            return count;
        }

        public static Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
            log.info("hScan(...) => key -> {}, options -> {}", new Object[]{key, JSON.toJSONString((Object)options)});
            Cursor cursor = redisTemplate.opsForHash().scan((Object)key, options);
            log.info("hScan(...) => cursor -> {}", new Object[]{JSON.toJSONString((Object)cursor)});
            return cursor;
        }
    }

    public static class StringOps {
        public static void set(String key, String value) {
            log.info("set(...) => key -> {}, value -> {}", new Object[]{key, value});
            redisTemplate.opsForValue().set((Object)key, (Object)value);
        }

        public static boolean setBit(String key, long offset, boolean value) {
            log.info("setBit(...) => key -> {}, offset -> {}, value -> {}", new Object[]{key, offset, value});
            Boolean result = redisTemplate.opsForValue().setBit((Object)key, offset, value);
            log.info("setBit(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static void setEx(String key, String value, long timeToLive, TimeUnit unit) {
            log.info("setEx(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, value, timeToLive, unit});
            redisTemplate.opsForValue().set((Object)key, (Object)value, timeToLive, unit);
        }

        public static boolean setIfAbsent(String key, String value) {
            log.info("setIfAbsent(...) => key -> {}, value -> {}", new Object[]{key, value});
            Boolean result = redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
            log.info("setIfAbsent(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static boolean setIfAbsent(String key, String value, long timeToLive, TimeUnit unit) {
            log.info("setIfAbsent(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, value, timeToLive, unit});
            Boolean result = redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeToLive, unit);
            log.info("setIfAbsent(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static void setRange(String key, String replaceValue, long offset) {
            log.info("setRange(...) => key -> {}, replaceValue -> {}, offset -> {}", new Object[]{key, replaceValue, offset});
            redisTemplate.opsForValue().set((Object)key, (Object)replaceValue, offset);
        }

        public static long size(String key) {
            log.info("size(...) => key -> {}", new Object[]{key});
            Long result = redisTemplate.opsForValue().size((Object)key);
            log.info("size(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static void multiSet(Map<String, String> maps) {
            log.info("multiSet(...) => maps -> {}", new Object[]{maps});
            redisTemplate.opsForValue().multiSet(maps);
        }

        public static boolean multiSetIfAbsent(Map<String, String> maps) {
            log.info("multiSetIfAbsent(...) => maps -> {}", new Object[]{maps});
            Boolean result = redisTemplate.opsForValue().multiSetIfAbsent(maps);
            log.info("multiSetIfAbsent(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static long incrBy(String key, long increment) {
            log.info("incrBy(...) => key -> {}, increment -> {}", new Object[]{key, increment});
            Long result = redisTemplate.opsForValue().increment((Object)key, increment);
            log.info("incrBy(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static double incrByFloat(String key, double increment) {
            log.info("incrByFloat(...) => key -> {}, increment -> {}", new Object[]{key, increment});
            Double result = redisTemplate.opsForValue().increment((Object)key, increment);
            log.info("incrByFloat(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static int append(String key, String value) {
            log.info("append(...) => key -> {}, value -> {}", new Object[]{key, value});
            Integer result = redisTemplate.opsForValue().append((Object)key, value);
            log.info("append(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static String get(String key) {
            log.info("get(...) => key -> {}", new Object[]{key});
            String result = (String)redisTemplate.opsForValue().get((Object)key);
            log.info("get(...) => result -> {} ", new Object[]{result});
            return result;
        }

        public static String getRange(String key, long start, long end) {
            log.info("getRange(...) => kry -> {}", new Object[]{key});
            String result = redisTemplate.opsForValue().get((Object)key, start, end);
            log.info("getRange(...) => result -> {} ", new Object[]{result});
            return result;
        }

        public static String getAndSet(String key, String newValue) {
            log.info("getAndSet(...) => key -> {}, value -> {}", new Object[]{key, newValue});
            String oldValue = (String)redisTemplate.opsForValue().getAndSet((Object)key, (Object)newValue);
            log.info("getAndSet(...) => oldValue -> {}", new Object[]{oldValue});
            return oldValue;
        }

        public static boolean getBit(String key, long offset) {
            log.info("getBit(...) => key -> {}, offset -> {}", new Object[]{key, offset});
            Boolean result = redisTemplate.opsForValue().getBit((Object)key, offset);
            log.info("getBit(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static List<String> multiGet(Collection<String> keys) {
            log.info("multiGet(...) => keys -> {}", new Object[]{keys});
            List result = redisTemplate.opsForValue().multiGet(keys);
            log.info("multiGet(...) => result -> {}", new Object[]{result});
            return result;
        }
    }

    public static class KeyOps {
        public static boolean delete(String key) {
            log.info("delete(...) => key -> {}", new Object[]{key});
            Boolean result = redisTemplate.delete((Object)key);
            log.info("delete(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static long delete(Collection<String> keys) {
            log.info("delete(...) => keys -> {}", new Object[]{keys});
            Long count = redisTemplate.delete(keys);
            log.info("delete(...) => count -> {}", new Object[]{count});
            if (count == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return count;
        }

        public static byte[] dump(String key) {
            log.info("dump(...) =>key -> {}", new Object[]{key});
            byte[] result = redisTemplate.dump((Object)key);
            log.info("dump(...) => result -> {}", new Object[]{Arrays.toString(result)});
            return result;
        }

        public static void restore(String key, byte[] value, long timeToLive, TimeUnit unit) {
            KeyOps.restore(key, value, timeToLive, unit, false);
        }

        public static void restore(String key, byte[] value, long timeToLive, TimeUnit unit, boolean replace) {
            log.info("restore(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}, replace -> {}", new Object[]{key, value, timeToLive, unit, replace});
            redisTemplate.restore((Object)key, value, timeToLive, unit, replace);
        }

        public static boolean hasKey(String key) {
            log.info("hasKey(...) => key -> {}", new Object[]{key});
            Boolean result = redisTemplate.hasKey((Object)key);
            log.info("hasKey(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static boolean expire(String key, long timeToLive, TimeUnit unit) {
            log.info("expire(...) => key -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, timeToLive, unit});
            Boolean result = redisTemplate.expire((Object)key, timeToLive, unit);
            log.info("expire(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static boolean expireAt(String key, Date date) {
            log.info("expireAt(...) => key -> {}, date -> {}", new Object[]{key, date});
            Boolean result = redisTemplate.expireAt((Object)key, date);
            log.info("expireAt(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static Set<String> keys(String pattern) {
            log.info("keys(...) => pattern -> {}", new Object[]{pattern});
            Set keys = redisTemplate.keys((Object)pattern);
            log.info("keys(...) => keys -> {}", new Object[]{keys});
            return keys;
        }

        public static boolean move(String key, int dbIndex) {
            log.info("move(...) => key  -> {}, dbIndex -> {}", new Object[]{key, dbIndex});
            Boolean result = redisTemplate.move((Object)key, dbIndex);
            log.info("move(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static boolean persist(String key) {
            log.info("persist(...) => key -> {}", new Object[]{key});
            Boolean result = redisTemplate.persist((Object)key);
            log.info("persist(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static long getExpire(String key) {
            return KeyOps.getExpire(key, TimeUnit.SECONDS);
        }

        public static long getExpire(String key, TimeUnit unit) {
            log.info("getExpire(...) =>key -> {}, unit is -> {}", new Object[]{key, unit});
            Long result = redisTemplate.getExpire((Object)key, unit);
            log.info("getExpire(...) => result ->  {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static String randomKey() {
            String result = (String)redisTemplate.randomKey();
            log.info("randomKey(...) => result -> {}", new Object[]{result});
            return result;
        }

        public static void rename(String oldKey, String newKey) {
            log.info("rename(...) => oldKey -> {}, newKey -> {}", new Object[]{oldKey, newKey});
            redisTemplate.rename((Object)oldKey, (Object)newKey);
        }

        public static boolean renameIfAbsent(String oldKey, String newKey) {
            log.info("renameIfAbsent(...) => oldKey -> {}, newKey -> {}", new Object[]{oldKey, newKey});
            Boolean result = redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
            log.info("renameIfAbsent(...) => result -> {}", new Object[]{result});
            if (result == null) {
                BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
            }
            return result;
        }

        public static DataType type(String key) {
            log.info("type(...) => key -> {}", new Object[]{key});
            DataType result = redisTemplate.type((Object)key);
            log.info("type(...) => result -> {}", new Object[]{result});
            return result;
        }
    }
}

