/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.config;

import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.isopen.commons.springboot.helper.ApplicationContextHelper;
import top.isopen.commons.springboot.helper.RedisHelper;
import top.isopen.commons.springboot.lock.RedLockAspect;
import top.isopen.commons.springboot.lock.RedLocksAspect;

@Configuration(proxyBeanMethods=false)
public class RedisConfig {
    @Bean
    @ConditionalOnBean(value={StringRedisTemplate.class})
    @ConditionalOnMissingBean(value={RedisHelper.class})
    public RedisHelper redisHelper(ApplicationContextHelper applicationContextHelper) {
        StringRedisTemplate stringRedisTemplate = applicationContextHelper.getBean(StringRedisTemplate.class);
        return new RedisHelper(stringRedisTemplate);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.KeyOps.class})
    public RedisHelper.KeyOps redisKeyOps(RedisHelper redisHelper) {
        return new RedisHelper.KeyOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.StringOps.class})
    public RedisHelper.StringOps redisStringOps(RedisHelper redisHelper) {
        return new RedisHelper.StringOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.HashOps.class})
    public RedisHelper.HashOps redisHashOps(RedisHelper redisHelper) {
        return new RedisHelper.HashOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.ListOps.class})
    public RedisHelper.ListOps redisListOps(RedisHelper redisHelper) {
        return new RedisHelper.ListOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.SetOps.class})
    public RedisHelper.SetOps redisSetOps(RedisHelper redisHelper) {
        return new RedisHelper.SetOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.ZSetOps.class})
    public RedisHelper.ZSetOps redisZSetOps(RedisHelper redisHelper) {
        return new RedisHelper.ZSetOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedisHelper.class})
    @ConditionalOnMissingBean(value={RedisHelper.LockOps.class})
    public RedisHelper.LockOps redisLockOps(RedisHelper redisHelper) {
        return new RedisHelper.LockOps(redisHelper);
    }

    @Bean
    @ConditionalOnBean(value={RedissonClient.class})
    @ConditionalOnMissingBean(value={RedLockAspect.class})
    public RedLockAspect redLockAspect(RedissonClient redissonClient) {
        return new RedLockAspect(redissonClient);
    }

    @Bean
    @ConditionalOnBean(value={RedissonClient.class})
    @ConditionalOnMissingBean(value={RedLocksAspect.class})
    public RedLocksAspect redLocksAspect(RedissonClient redissonClient) {
        return new RedLocksAspect(redissonClient);
    }
}

