/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.util;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.support.SFunction;
import top.isopen.commons.springboot.util.NameUtil;

public class FieldUtil {
    private static final Log log = LogFactory.getLog(FieldUtil.class);
    private static final String WRITE_REPLACE = "writeReplace";
    private static final String[] PREFIXES = new String[]{"is", "get"};

    public static <T> String resolveName(SFunction<T, ?> func) {
        log.info("resolving entity name of SFunction: {}", new Object[]{func.toString()});
        try {
            Method method = func.getClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            method.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
            String methodName = serializedLambda.getImplMethodName();
            return FieldUtil.resolveName(methodName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("error come where resolving entity name of SFunction: {}", (Throwable)e);
            return null;
        }
    }

    public static String resolveName(String methodName) {
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        for (String prefix : PREFIXES) {
            if (!methodName.startsWith(prefix)) continue;
            String name = methodName.substring(prefix.length());
            return NameUtil.humpToUnderline(name.substring(0, 1).toLowerCase() + name.substring(1));
        }
        return null;
    }
}

