/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.helper;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.enums.BaseErrorEnum;

public class RedisHelper {
    public final long DEFAULT_LOCK_TIMEOUT = 3L;
    public final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final Log log = LogFactory.getLog(RedisHelper.class);
    private final StringRedisTemplate redisTemplate;
    private final String RELEASE_LOCK_LUA;

    public RedisHelper(StringRedisTemplate redisTemplate) {
        this.RELEASE_LOCK_LUA = "if redis.call('get',KEYS[1]) == ARGV[1] then     return redis.call('del',KEYS[1]) else     return 0 end ";
        this.redisTemplate = redisTemplate;
    }

    public boolean delete(String key) {
        this.log.info("delete(...) => key -> {}", new Object[]{key});
        Boolean result = this.redisTemplate.delete((Object)key);
        this.log.info("delete(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long delete(Collection<String> keys) {
        this.log.info("delete(...) => keys -> {}", new Object[]{keys});
        Long count = this.redisTemplate.delete(keys);
        this.log.info("delete(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public byte[] dump(String key) {
        this.log.info("dump(...) =>key -> {}", new Object[]{key});
        byte[] result = this.redisTemplate.dump((Object)key);
        this.log.info("dump(...) => result -> {}", new Object[]{Arrays.toString(result)});
        return result;
    }

    public void restore(String key, byte[] value, long timeToLive, TimeUnit unit) {
        this.restore(key, value, timeToLive, unit, false);
    }

    public void restore(String key, byte[] value, long timeToLive, TimeUnit unit, boolean replace) {
        this.log.info("restore(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}, replace -> {}", new Object[]{key, value, timeToLive, unit, replace});
        this.redisTemplate.restore((Object)key, value, timeToLive, unit, replace);
    }

    public boolean hasKey(String key) {
        this.log.info("hasKey(...) => key -> {}", new Object[]{key});
        Boolean result = this.redisTemplate.hasKey((Object)key);
        this.log.info("hasKey(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean expire(String key, long timeToLive, TimeUnit unit) {
        this.log.info("expire(...) => key -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, timeToLive, unit});
        Boolean result = this.redisTemplate.expire((Object)key, timeToLive, unit);
        this.log.info("expire(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean expireAt(String key, Date date) {
        this.log.info("expireAt(...) => key -> {}, date -> {}", new Object[]{key, date});
        Boolean result = this.redisTemplate.expireAt((Object)key, date);
        this.log.info("expireAt(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public Set<String> keys(String pattern) {
        this.log.info("keys(...) => pattern -> {}", new Object[]{pattern});
        Set keys = this.redisTemplate.keys((Object)pattern);
        this.log.info("keys(...) => keys -> {}", new Object[]{keys});
        return keys;
    }

    public boolean move(String key, int dbIndex) {
        this.log.info("move(...) => key  -> {}, dbIndex -> {}", new Object[]{key, dbIndex});
        Boolean result = this.redisTemplate.move((Object)key, dbIndex);
        this.log.info("move(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean persist(String key) {
        this.log.info("persist(...) => key -> {}", new Object[]{key});
        Boolean result = this.redisTemplate.persist((Object)key);
        this.log.info("persist(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long getExpire(String key) {
        return this.getExpire(key, TimeUnit.SECONDS);
    }

    public long getExpire(String key, TimeUnit unit) {
        this.log.info("getExpire(...) =>key -> {}, unit is -> {}", new Object[]{key, unit});
        Long result = this.redisTemplate.getExpire((Object)key, unit);
        this.log.info("getExpire(...) => result ->  {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public String randomKey() {
        String result = (String)this.redisTemplate.randomKey();
        this.log.info("randomKey(...) => result -> {}", new Object[]{result});
        return result;
    }

    public void rename(String oldKey, String newKey) {
        this.log.info("rename(...) => oldKey -> {}, newKey -> {}", new Object[]{oldKey, newKey});
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public boolean renameIfAbsent(String oldKey, String newKey) {
        this.log.info("renameIfAbsent(...) => oldKey -> {}, newKey -> {}", new Object[]{oldKey, newKey});
        Boolean result = this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
        this.log.info("renameIfAbsent(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public DataType type(String key) {
        this.log.info("type(...) => key -> {}", new Object[]{key});
        DataType result = this.redisTemplate.type((Object)key);
        this.log.info("type(...) => result -> {}", new Object[]{result});
        return result;
    }

    public void set(String key, String value) {
        this.log.info("set(...) => key -> {}, value -> {}", new Object[]{key, value});
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public boolean setBit(String key, long offset, boolean value) {
        this.log.info("setBit(...) => key -> {}, offset -> {}, value -> {}", new Object[]{key, offset, value});
        Boolean result = this.redisTemplate.opsForValue().setBit((Object)key, offset, value);
        this.log.info("setBit(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public void setEx(String key, String value, long timeToLive, TimeUnit unit) {
        this.log.info("setEx(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, value, timeToLive, unit});
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeToLive, unit);
    }

    public boolean setIfAbsent(String key, String value) {
        this.log.info("setIfAbsent(...) => key -> {}, value -> {}", new Object[]{key, value});
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
        this.log.info("setIfAbsent(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean setIfAbsent(String key, String value, long timeToLive, TimeUnit unit) {
        this.log.info("setIfAbsent(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, value, timeToLive, unit});
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeToLive, unit);
        this.log.info("setIfAbsent(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public void setRange(String key, String replaceValue, long offset) {
        this.log.info("setRange(...) => key -> {}, replaceValue -> {}, offset -> {}", new Object[]{key, replaceValue, offset});
        this.redisTemplate.opsForValue().set((Object)key, (Object)replaceValue, offset);
    }

    public long size(String key) {
        this.log.info("size(...) => key -> {}", new Object[]{key});
        Long result = this.redisTemplate.opsForValue().size((Object)key);
        this.log.info("size(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public void multiSet(Map<String, String> maps) {
        this.log.info("multiSet(...) => maps -> {}", new Object[]{maps});
        this.redisTemplate.opsForValue().multiSet(maps);
    }

    public boolean multiSetIfAbsent(Map<String, String> maps) {
        this.log.info("multiSetIfAbsent(...) => maps -> {}", new Object[]{maps});
        Boolean result = this.redisTemplate.opsForValue().multiSetIfAbsent(maps);
        this.log.info("multiSetIfAbsent(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long incrBy(String key, long increment) {
        this.log.info("incrBy(...) => key -> {}, increment -> {}", new Object[]{key, increment});
        Long result = this.redisTemplate.opsForValue().increment((Object)key, increment);
        this.log.info("incrBy(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public double incrByFloat(String key, double increment) {
        this.log.info("incrByFloat(...) => key -> {}, increment -> {}", new Object[]{key, increment});
        Double result = this.redisTemplate.opsForValue().increment((Object)key, increment);
        this.log.info("incrByFloat(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public int append(String key, String value) {
        this.log.info("append(...) => key -> {}, value -> {}", new Object[]{key, value});
        Integer result = this.redisTemplate.opsForValue().append((Object)key, value);
        this.log.info("append(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public String get(String key) {
        this.log.info("get(...) => key -> {}", new Object[]{key});
        String result = (String)this.redisTemplate.opsForValue().get((Object)key);
        this.log.info("get(...) => result -> {} ", new Object[]{result});
        return result;
    }

    public String getRange(String key, long start, long end) {
        this.log.info("getRange(...) => kry -> {}", new Object[]{key});
        String result = this.redisTemplate.opsForValue().get((Object)key, start, end);
        this.log.info("getRange(...) => result -> {} ", new Object[]{result});
        return result;
    }

    public String getAndSet(String key, String newValue) {
        this.log.info("getAndSet(...) => key -> {}, value -> {}", new Object[]{key, newValue});
        String oldValue = (String)this.redisTemplate.opsForValue().getAndSet((Object)key, (Object)newValue);
        this.log.info("getAndSet(...) => oldValue -> {}", new Object[]{oldValue});
        return oldValue;
    }

    public boolean getBit(String key, long offset) {
        this.log.info("getBit(...) => key -> {}, offset -> {}", new Object[]{key, offset});
        Boolean result = this.redisTemplate.opsForValue().getBit((Object)key, offset);
        this.log.info("getBit(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public List<String> multiGet(Collection<String> keys) {
        this.log.info("multiGet(...) => keys -> {}", new Object[]{keys});
        List result = this.redisTemplate.opsForValue().multiGet(keys);
        this.log.info("multiGet(...) => result -> {}", new Object[]{result});
        return result;
    }

    public void hPut(String key, String entryKey, String entryValue) {
        this.log.info("hPut(...) => key -> {}, entryKey -> {}, entryValue -> {}", new Object[]{key, entryKey, entryValue});
        this.redisTemplate.opsForHash().put((Object)key, (Object)entryKey, (Object)entryValue);
    }

    public void hPutAll(String key, Map<String, String> maps) {
        this.log.info("hPutAll(...) => key -> {}, maps -> {}", new Object[]{key, maps});
        this.redisTemplate.opsForHash().putAll((Object)key, maps);
    }

    public boolean hPutIfAbsent(String key, String entryKey, String entryValue) {
        this.log.info("hPutIfAbsent(...) => key -> {}, entryKey -> {}, entryValue -> {}", new Object[]{key, entryKey, entryValue});
        Boolean result = this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)entryKey, (Object)entryValue);
        this.log.info("hPutIfAbsent(...) => result -> {}", new Object[]{result});
        return result;
    }

    public Object hGet(String key, String entryKey) {
        this.log.info("hGet(...) => key -> {}, entryKey -> {}", new Object[]{key, entryKey});
        Object entryValue = this.redisTemplate.opsForHash().get((Object)key, (Object)entryKey);
        this.log.info("hGet(...) => entryValue -> {}", new Object[]{entryValue});
        return entryValue;
    }

    public Map<Object, Object> hGetAll(String key) {
        this.log.info("hGetAll(...) => key -> {}", new Object[]{key});
        Map result = this.redisTemplate.opsForHash().entries((Object)key);
        this.log.info("hGetAll(...) => result -> {}", new Object[]{result});
        return result;
    }

    public List<Object> hMultiGet(String key, Collection<Object> entryKeys) {
        this.log.info("hMultiGet(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKeys});
        List entryValues = this.redisTemplate.opsForHash().multiGet((Object)key, entryKeys);
        this.log.info("hMultiGet(...) => entryValues -> {}", new Object[]{entryValues});
        return entryValues;
    }

    public long hDelete(String key, Object ... entryKeys) {
        this.log.info("hDelete(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKeys});
        Long count = this.redisTemplate.opsForHash().delete((Object)key, entryKeys);
        this.log.info("hDelete(...) => count -> {}", new Object[]{count});
        return count;
    }

    public boolean hExists(String key, String entryKey) {
        this.log.info("hDelete(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKey});
        Boolean exist = this.redisTemplate.opsForHash().hasKey((Object)key, (Object)entryKey);
        this.log.info("hDelete(...) => exist -> {}", new Object[]{exist});
        return exist;
    }

    public long hIncrBy(String key, Object entryKey, long increment) {
        this.log.info("hIncrBy(...) => key -> {}, entryKey -> {}, increment -> {}", new Object[]{key, entryKey, increment});
        Long result = this.redisTemplate.opsForHash().increment((Object)key, entryKey, increment);
        this.log.info("hIncrBy(...) => result -> {}", new Object[]{result});
        return result;
    }

    public double hIncrByFloat(String key, Object entryKey, double increment) {
        this.log.info("hIncrByFloat(...) => key -> {}, entryKey -> {}, increment -> {}", new Object[]{key, entryKey, increment});
        Double result = this.redisTemplate.opsForHash().increment((Object)key, entryKey, increment);
        this.log.info("hIncrByFloat(...) => result -> {}", new Object[]{result});
        return result;
    }

    public Set<Object> hKeys(String key) {
        this.log.info("hKeys(...) => key -> {}", new Object[]{key});
        Set entryKeys = this.redisTemplate.opsForHash().keys((Object)key);
        this.log.info("hKeys(...) => entryKeys -> {}", new Object[]{entryKeys});
        return entryKeys;
    }

    public List<Object> hValues(String key) {
        this.log.info("hValues(...) => key -> {}", new Object[]{key});
        List entryValues = this.redisTemplate.opsForHash().values((Object)key);
        this.log.info("hValues(...) => entryValues -> {}", new Object[]{entryValues});
        return entryValues;
    }

    public long hSize(String key) {
        this.log.info("hSize(...) => key -> {}", new Object[]{key});
        Long count = this.redisTemplate.opsForHash().size((Object)key);
        this.log.info("hSize(...) => count -> {}", new Object[]{count});
        return count;
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
        this.log.info("hScan(...) => key -> {}, options -> {}", new Object[]{key, JSON.toJSONString((Object)options)});
        Cursor cursor = this.redisTemplate.opsForHash().scan((Object)key, options);
        this.log.info("hScan(...) => cursor -> {}", new Object[]{JSON.toJSONString((Object)cursor)});
        return cursor;
    }

    public long lLeftPush(String key, String item) {
        this.log.info("lLeftPush(...) => key -> {}, item -> {}", new Object[]{key, item});
        Long size = this.redisTemplate.opsForList().leftPush((Object)key, (Object)item);
        this.log.info("lLeftPush(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPushAll(String key, String ... items) {
        this.log.info("lLeftPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long size = this.redisTemplate.opsForList().leftPushAll((Object)key, (Object[])items);
        this.log.info("lLeftPushAll(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPushAll(String key, Collection<String> items) {
        this.log.info("lLeftPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long size = this.redisTemplate.opsForList().leftPushAll((Object)key, items);
        this.log.info("lLeftPushAll(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPushIfPresent(String key, String item) {
        this.log.info("lLeftPushIfPresent(...) => key -> {}, item -> {}", new Object[]{key, item});
        Long size = this.redisTemplate.opsForList().leftPushIfPresent((Object)key, (Object)item);
        this.log.info("lLeftPushIfPresent(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPush(String key, String pivot, String item) {
        this.log.info("lLeftPush(...) => key -> {}, pivot -> {}, item -> {}", new Object[]{key, pivot, item});
        Long size = this.redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)item);
        this.log.info("lLeftPush(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPush(String key, String item) {
        this.log.info("lRightPush(...) => key -> {}, item -> {}", new Object[]{key, item});
        Long size = this.redisTemplate.opsForList().rightPush((Object)key, (Object)item);
        this.log.info("lRightPush(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPushAll(String key, String ... items) {
        this.log.info("lRightPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long size = this.redisTemplate.opsForList().rightPushAll((Object)key, (Object[])items);
        this.log.info("lRightPushAll(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPushAll(String key, Collection<String> items) {
        this.log.info("lRightPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long size = this.redisTemplate.opsForList().rightPushAll((Object)key, items);
        this.log.info("lRightPushAll(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPushIfPresent(String key, String item) {
        this.log.info("lRightPushIfPresent(...) => key -> {}, item -> {}", new Object[]{key, item});
        Long size = this.redisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)item);
        this.log.info("lRightPushIfPresent(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPush(String key, String pivot, String item) {
        this.log.info("lLeftPush(...) => key -> {}, pivot -> {}, item -> {}", new Object[]{key, pivot, item});
        Long size = this.redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, (Object)item);
        this.log.info("lLeftPush(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public String lLeftPop(String key) {
        this.log.info("lLeftPop(...) => key -> {}", new Object[]{key});
        String item = (String)this.redisTemplate.opsForList().leftPop((Object)key);
        this.log.info("lLeftPop(...) => item -> {}", new Object[]{item});
        return item;
    }

    public String lLeftPop(String key, long timeout, TimeUnit unit) {
        this.log.info("lLeftPop(...) => key -> {}, timeout -> {}, unit -> {}", new Object[]{key, timeout, unit});
        String item = (String)this.redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
        this.log.info("lLeftPop(...) => item -> {}", new Object[]{item});
        return item;
    }

    public String lRightPop(String key) {
        this.log.info("lRightPop(...) => key -> {}", new Object[]{key});
        String item = (String)this.redisTemplate.opsForList().rightPop((Object)key);
        this.log.info("lRightPop(...) => item -> {}", new Object[]{item});
        return item;
    }

    public String lRightPop(String key, long timeout, TimeUnit unit) {
        this.log.info("lRightPop(...) => key -> {}, timeout -> {}, unit -> {}", new Object[]{key, timeout, unit});
        String item = (String)this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
        this.log.info("lRightPop(...) => item -> {}", new Object[]{item});
        return item;
    }

    public String lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        this.log.info("lRightPopAndLeftPush(...) => sourceKey -> {}, destinationKey -> {}", new Object[]{sourceKey, destinationKey});
        String item = (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
        this.log.info("lRightPopAndLeftPush(...) => item -> {}", new Object[]{item});
        return item;
    }

    public String lRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        this.log.info("lRightPopAndLeftPush(...) => sourceKey -> {}, destinationKey -> {}, timeout -> {}, unit -> {}", new Object[]{sourceKey, destinationKey, timeout, unit});
        String item = (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
        this.log.info("lRightPopAndLeftPush(...) => item -> {}", new Object[]{item});
        return item;
    }

    public void lSet(String key, long index, String item) {
        this.log.info("lSet(...) => key -> {}, index -> {}, item -> {}", new Object[]{key, index, item});
        this.redisTemplate.opsForList().set((Object)key, index, (Object)item);
    }

    public String lIndex(String key, long index) {
        this.log.info("lIndex(...) => key -> {}, index -> {}", new Object[]{key, index});
        String item = (String)this.redisTemplate.opsForList().index((Object)key, index);
        this.log.info("lIndex(...) => item -> {}", new Object[]{item});
        return item;
    }

    public List<String> lRange(String key, long start, long end) {
        this.log.info("lRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        List result = this.redisTemplate.opsForList().range((Object)key, start, end);
        this.log.info("lRange(...) => result -> {}", new Object[]{result});
        return result;
    }

    public List<String> lWholeList(String key) {
        this.log.info("lWholeList(...) => key -> {}", new Object[]{key});
        List result = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        this.log.info("lWholeList(...) => result -> {}", new Object[]{result});
        return result;
    }

    public long lSize(String key) {
        this.log.info("lSize(...) => key -> {}", new Object[]{key});
        Long size = this.redisTemplate.opsForList().size((Object)key);
        this.log.info("lSize(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRemove(String key, long expectCount, String item) {
        this.log.info("lRemove(...) => key -> {}, expectCount -> {}, item -> {}", new Object[]{key, expectCount, item});
        Long actualCount = this.redisTemplate.opsForList().remove((Object)key, expectCount, (Object)item);
        this.log.info("lRemove(...) => actualCount -> {}", new Object[]{actualCount});
        if (actualCount == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return actualCount;
    }

    public void lTrim(String key, long start, long end) {
        this.log.info("lTrim(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        this.redisTemplate.opsForList().trim((Object)key, start, end);
    }

    public long sAdd(String key, String ... items) {
        this.log.info("sAdd(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long count = this.redisTemplate.opsForSet().add((Object)key, (Object[])items);
        this.log.info("sAdd(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long sRemove(String key, Object ... items) {
        this.log.info("sRemove(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long count = this.redisTemplate.opsForSet().remove((Object)key, items);
        this.log.info("sRemove(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public String sPop(String key) {
        this.log.info("sPop(...) => key -> {}", new Object[]{key});
        String popItem = (String)this.redisTemplate.opsForSet().pop((Object)key);
        this.log.info("sPop(...) => popItem -> {}", new Object[]{popItem});
        return popItem;
    }

    public boolean sMove(String sourceKey, String item, String destinationKey) {
        Boolean result = this.redisTemplate.opsForSet().move((Object)sourceKey, (Object)item, (Object)destinationKey);
        this.log.info("sMove(...) => sourceKey -> {}, destinationKey -> {}, item -> {}", new Object[]{sourceKey, destinationKey, item});
        this.log.info("sMove(...) =>  result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long sSize(String key) {
        this.log.info("sSize(...) => key -> {}", new Object[]{key});
        Long size = this.redisTemplate.opsForSet().size((Object)key);
        this.log.info("sSize(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public boolean sIsMember(String key, Object item) {
        this.log.info("sSize(...) => key -> {}, size -> {}", new Object[]{key, item});
        Boolean result = this.redisTemplate.opsForSet().isMember((Object)key, item);
        this.log.info("sSize(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public Set<String> sIntersect(String key, String otherKey) {
        this.log.info("sIntersect(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
        Set intersectResult = this.redisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
        this.log.info("sIntersect(...) => intersectResult -> {}", new Object[]{intersectResult});
        return intersectResult;
    }

    public Set<String> sIntersect(String key, Collection<String> otherKeys) {
        this.log.info("sIntersect(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
        Set intersectResult = this.redisTemplate.opsForSet().intersect((Object)key, otherKeys);
        this.log.info("sIntersect(...) => intersectResult -> {}", new Object[]{intersectResult});
        return intersectResult;
    }

    public long sIntersectAndStore(String key, String otherKey, String storeKey) {
        this.log.info("sIntersectAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
        Long size = this.redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        this.log.info("sIntersectAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long sIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
        this.log.info("sIntersectAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
        Long size = this.redisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
        this.log.info("sIntersectAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Set<String> sUnion(String key, String otherKey) {
        this.log.info("sUnion(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
        Set unionResult = this.redisTemplate.opsForSet().union((Object)key, (Object)otherKey);
        this.log.info("sUnion(...) => unionResult -> {}", new Object[]{unionResult});
        return unionResult;
    }

    public Set<String> sUnion(String key, Collection<String> otherKeys) {
        this.log.info("sUnion(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
        Set unionResult = this.redisTemplate.opsForSet().union((Object)key, otherKeys);
        this.log.info("sUnion(...) => unionResult -> {}", new Object[]{unionResult});
        return unionResult;
    }

    public long sUnionAndStore(String key, String otherKey, String storeKey) {
        this.log.info("sUnionAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
        Long size = this.redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        this.log.info("sUnionAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long sUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
        this.log.info("sUnionAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
        Long size = this.redisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
        this.log.info("sUnionAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Set<String> sDifference(String key, String otherKey) {
        this.log.info("sDifference(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
        Set differenceResult = this.redisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
        this.log.info("sDifference(...) => differenceResult -> {}", new Object[]{differenceResult});
        return differenceResult;
    }

    public Set<String> sDifference(String key, Collection<String> otherKeys) {
        this.log.info("sDifference(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
        Set differenceResult = this.redisTemplate.opsForSet().difference((Object)key, otherKeys);
        this.log.info("sDifference(...) => differenceResult -> {}", new Object[]{differenceResult});
        return differenceResult;
    }

    public long sDifferenceAndStore(String key, String otherKey, String storeKey) {
        this.log.info("sDifferenceAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
        Long size = this.redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        this.log.info("sDifferenceAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long sDifferenceAndStore(String key, Collection<String> otherKeys, String storeKey) {
        this.log.info("sDifferenceAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
        Long size = this.redisTemplate.opsForSet().differenceAndStore((Object)key, otherKeys, (Object)storeKey);
        this.log.info("sDifferenceAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Set<String> sMembers(String key) {
        this.log.info("sMembers(...) => key -> {}", new Object[]{key});
        Set members = this.redisTemplate.opsForSet().members((Object)key);
        this.log.info("sMembers(...) => members -> {}", new Object[]{members});
        return members;
    }

    public String sRandomMember(String key) {
        this.log.info("sRandomMember(...) => key -> {}", new Object[]{key});
        String randomItem = (String)this.redisTemplate.opsForSet().randomMember((Object)key);
        this.log.info("sRandomMember(...) => randomItem -> {}", new Object[]{randomItem});
        return randomItem;
    }

    public List<String> sRandomMembers(String key, long count) {
        this.log.info("sRandomMembers(...) => key -> {}, count -> {}", new Object[]{key, count});
        List randomItems = this.redisTemplate.opsForSet().randomMembers((Object)key, count);
        this.log.info("sRandomMembers(...) => randomItems -> {}", new Object[]{randomItems});
        return randomItems;
    }

    public Set<String> sDistinctRandomMembers(String key, long count) {
        this.log.info("sDistinctRandomMembers(...) => key -> {}, count -> {}", new Object[]{key, count});
        Set distinctRandomItems = this.redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
        this.log.info("sDistinctRandomMembers(...) => distinctRandomItems -> {}", new Object[]{distinctRandomItems});
        return distinctRandomItems;
    }

    public Cursor<String> sScan(String key, ScanOptions options) {
        this.log.info("sScan(...) => key -> {}, options -> {}", new Object[]{key, JSON.toJSONString((Object)options)});
        Cursor cursor = this.redisTemplate.opsForSet().scan((Object)key, options);
        this.log.info("sScan(...) => cursor -> {}", new Object[]{JSON.toJSONString((Object)cursor)});
        return cursor;
    }

    public boolean zAdd(String key, String item, double score) {
        this.log.info("zAdd(...) => key -> {}, item -> {}, score -> {}", new Object[]{key, item, score});
        Boolean result = this.redisTemplate.opsForZSet().add((Object)key, (Object)item, score);
        this.log.info("zAdd(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long zAdd(String key, Set<ZSetOperations.TypedTuple<String>> entries) {
        this.log.info("zAdd(...) => key -> {}, entries -> {}", new Object[]{key, JSON.toJSONString(entries)});
        Long count = this.redisTemplate.opsForZSet().add((Object)key, entries);
        this.log.info("zAdd(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zRemove(String key, Object ... items) {
        this.log.info("zRemove(...) => key -> {}, items -> {}", new Object[]{key, items});
        Long count = this.redisTemplate.opsForZSet().remove((Object)key, items);
        this.log.info("zRemove(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zRemoveRange(String key, long startRange, long endRange) {
        this.log.info("zRemoveRange(...) => key -> {}, startRange -> {}, endRange -> {}", new Object[]{key, startRange, endRange});
        Long count = this.redisTemplate.opsForZSet().removeRange((Object)key, startRange, endRange);
        this.log.info("zRemoveRange(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zRemoveRangeByScore(String key, double minScore, double maxScore) {
        this.log.info("zRemoveRangeByScore(...) => key -> {}, startIndex -> {}, startIndex -> {}", new Object[]{key, minScore, maxScore});
        Long count = this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, minScore, maxScore);
        this.log.info("zRemoveRangeByScore(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public double zIncrementScore(String key, String item, double delta) {
        this.log.info("zIncrementScore(...) => key -> {}, item -> {}, delta -> {}", new Object[]{key, item, delta});
        Double scoreValue = this.redisTemplate.opsForZSet().incrementScore((Object)key, (Object)item, delta);
        this.log.info("zIncrementScore(...) => scoreValue -> {}", new Object[]{scoreValue});
        if (scoreValue == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return scoreValue;
    }

    public long zRank(String key, Object item) {
        this.log.info("zRank(...) => key -> {}, item -> {}", new Object[]{key, item});
        Long rank = this.redisTemplate.opsForZSet().rank((Object)key, item);
        this.log.info("zRank(...) => rank -> {}", new Object[]{rank});
        if (rank == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return rank;
    }

    public long zReverseRank(String key, Object item) {
        this.log.info("zReverseRank(...) => key -> {}, item -> {}", new Object[]{key, item});
        Long reverseRank = this.redisTemplate.opsForZSet().reverseRank((Object)key, item);
        this.log.info("zReverseRank(...) => reverseRank -> {}", new Object[]{reverseRank});
        if (reverseRank == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return reverseRank;
    }

    public Set<String> zRange(String key, long start, long end) {
        this.log.info("zRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        Set result = this.redisTemplate.opsForZSet().range((Object)key, start, end);
        this.log.info("zRange(...) => result -> {}", new Object[]{result});
        return result;
    }

    public Set<String> zWholeZSetItem(String key) {
        this.log.info("zWholeZSetItem(...) => key -> {}", new Object[]{key});
        Set result = this.redisTemplate.opsForZSet().range((Object)key, 0L, -1L);
        this.log.info("zWholeZSetItem(...) =>result -> {}", new Object[]{result});
        return result;
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeWithScores(String key, long start, long end) {
        this.log.info("zRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        Set entries = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
        this.log.info("zRangeWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        return entries;
    }

    public Set<ZSetOperations.TypedTuple<String>> zWholeZSetEntry(String key) {
        this.log.info("zWholeZSetEntry(...) => key -> {}", new Object[]{key});
        Set entries = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, 0L, -1L);
        this.log.info("zWholeZSetEntry(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        return entries;
    }

    public Set<String> zRangeByScore(String key, double minScore, double maxScore) {
        this.log.info("zRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
        Set items = this.redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore);
        this.log.info("zRangeByScore(...) => items -> {}", new Object[]{items});
        return items;
    }

    public Set<String> zRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
        this.log.info("zRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
        Set items = this.redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore, offset, count);
        this.log.info("zRangeByScore(...) => items -> {}", new Object[]{items});
        return items;
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double minScore, double maxScore) {
        this.log.info("zRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
        Set entries = this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore);
        this.log.info("zRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        return entries;
    }

    public Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double minScore, double maxScore, long offset, long count) {
        this.log.info("zRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
        Set entries = this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore, offset, count);
        this.log.info("zRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        return entries;
    }

    public Set<String> zReverseRange(String key, long start, long end) {
        this.log.info("zReverseRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        Set entries = this.redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
        this.log.info("zReverseRange(...) => entries -> {}", new Object[]{entries});
        return entries;
    }

    public Set<ZSetOperations.TypedTuple<String>> zReverseRangeWithScores(String key, long start, long end) {
        this.log.info("zReverseRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        Set entries = this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
        this.log.info("zReverseRangeWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        return entries;
    }

    public Set<String> zReverseRangeByScore(String key, double minScore, double maxScore) {
        this.log.info("zReverseRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
        Set items = this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore);
        this.log.info("zReverseRangeByScore(...) => items -> {}", new Object[]{items});
        return items;
    }

    public Set<ZSetOperations.TypedTuple<String>> zReverseRangeByScoreWithScores(String key, double minScore, double maxScore) {
        this.log.info("zReverseRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
        Set entries = this.redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, minScore, maxScore);
        this.log.info("zReverseRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        return entries;
    }

    public Set<String> zReverseRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
        this.log.info("zReverseRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
        Set items = this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore, offset, count);
        this.log.info("items -> {}", new Object[]{items});
        return items;
    }

    public long zCount(String key, double minScore, double maxScore) {
        this.log.info("zCount(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
        Long count = this.redisTemplate.opsForZSet().count((Object)key, minScore, maxScore);
        this.log.info("zCount(...) => count -> {}", new Object[]{count});
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zSize(String key) {
        this.log.info("zSize(...) => key -> {}", new Object[]{key});
        Long size = this.redisTemplate.opsForZSet().size((Object)key);
        this.log.info("zSize(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zZCard(String key) {
        this.log.info("zZCard(...) => key -> {}", new Object[]{key});
        Long size = this.redisTemplate.opsForZSet().zCard((Object)key);
        this.log.info("zZCard(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public double zScore(String key, Object item) {
        this.log.info("zScore(...) => key -> {}, item -> {}", new Object[]{key, item});
        Double score = this.redisTemplate.opsForZSet().score((Object)key, item);
        this.log.info("zScore(...) => score -> {}", new Object[]{score});
        if (score == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return score;
    }

    public long zUnionAndStore(String key, String otherKey, String storeKey) {
        this.log.info("zUnionAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
        Long size = this.redisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        this.log.info("zUnionAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
        this.log.info("zUnionAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
        Long size = this.redisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
        this.log.info("zUnionAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zIntersectAndStore(String key, String otherKey, String storeKey) {
        this.log.info("zIntersectAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
        Long size = this.redisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        this.log.info("zIntersectAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
        this.log.info("zIntersectAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
        Long size = this.redisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
        this.log.info("zIntersectAndStore(...) => size -> {}", new Object[]{size});
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public boolean getLock(String key, String value) {
        return this.getLock(key, value, 3L, this.DEFAULT_TIMEOUT_UNIT);
    }

    public boolean getLockUntilTimeout(String key, String value, long retryTimeoutLimit) {
        return this.getLockUntilTimeout(key, value, 3L, this.DEFAULT_TIMEOUT_UNIT, retryTimeoutLimit);
    }

    public boolean getLockUntilTimeout(String key, String value, long timeout, TimeUnit unit, long retryTimeoutLimit) {
        long startTime;
        this.log.info("getLockUntilTimeout(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}, retryTimeoutLimit -> {}ms", new Object[]{key, value, timeout, unit, retryTimeoutLimit});
        long now = startTime = Instant.now().toEpochMilli();
        do {
            try {
                boolean alreadyGotLock = this.getLock(key, value, timeout, unit, false);
                if (alreadyGotLock) {
                    this.log.info("getLockUntilTimeout(...) => consume time -> {}ms, result -> true", new Object[]{now - startTime});
                    return true;
                }
            }
            catch (Exception e) {
                this.log.warn("getLockUntilTimeout(...) => try to get lock failure! e.getMessage -> {}", new Object[]{e.getMessage()});
            }
        } while ((now = Instant.now().toEpochMilli()) < startTime + retryTimeoutLimit);
        this.log.info("getLockUntilTimeout(...) => consume time -> {}ms, result -> false", new Object[]{now - startTime});
        return false;
    }

    public boolean getLock(String key, String value, long timeout, TimeUnit unit) {
        return this.getLock(key, value, timeout, unit, true);
    }

    public boolean getLock(String key, String value, long timeout, TimeUnit unit, boolean recordLog) {
        if (recordLog) {
            this.log.info("getLock(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}", new Object[]{key, value, timeout, unit});
        }
        Boolean result = (Boolean)this.redisTemplate.execute(connection -> connection.set(key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8), Expiration.seconds((long)unit.toSeconds(timeout)), RedisStringCommands.SetOption.SET_IF_ABSENT));
        if (recordLog) {
            this.log.info("getLock(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean releaseLock(String key, String value) {
        this.log.info("releaseLock(...) => key -> {}, lockValue -> {}", new Object[]{key, value});
        Boolean result = (Boolean)this.redisTemplate.execute(connection -> (Boolean)connection.eval(this.RELEASE_LOCK_LUA.getBytes(), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8)}));
        this.log.info("releaseLock(...) => result -> {}", new Object[]{result});
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public static class Helper {
        public static final String DEFAULT_SYMBOL = ":";

        public static String join(String ... args) {
            return Helper.joinBySymbol(DEFAULT_SYMBOL, args);
        }

        public static String joinBySymbol(String symbol, String ... args) {
            if (symbol == null || symbol.trim().length() == 0) {
                throw new RuntimeException(" symbol must not be empty!");
            }
            if (args == null || args.length == 0) {
                throw new RuntimeException(" args must not be empty!");
            }
            StringBuilder sb = new StringBuilder(16);
            for (String arg : args) {
                sb.append(arg).append(symbol);
            }
            sb.replace(sb.length() - symbol.length(), sb.length(), "");
            return sb.toString();
        }
    }
}

