/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.isopen.commons.springboot.enums.QueryTypeEnum;
import top.isopen.commons.springboot.model.AbstractModel;
import top.isopen.commons.springboot.types.AbstractType;
import top.isopen.commons.springboot.types.OrderBy;
import top.isopen.commons.springboot.types.OrderByList;
import top.isopen.commons.springboot.types.Query;
import top.isopen.commons.springboot.util.FieldUtil;

public abstract class AbstractRepository<T extends AbstractType<T, ?>, R extends AbstractModel<R, ?>> {
    protected QueryWrapper<R> queryWrapper(@Nullable T query, OrderBy<R> ... orderby) {
        return this.queryWrapper(query, new OrderByList<R>(orderby));
    }

    protected QueryWrapper<R> queryWrapper(@Nullable T query, @Nullable OrderByList<R> orderByList) {
        return this.queryWrapper(query, orderByList != null ? orderByList.getOrderByList() : null);
    }

    protected QueryWrapper<R> queryWrapper(@Nullable T query, @Nullable List<OrderBy<R>> orderByList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (query != null) {
            List<Query<R>> queryList = this.buildQueryEntity(query);
            for (Query<R> queryEntity : queryList) {
                QueryTypeEnum queryType = queryEntity.getType();
                String fieldName = FieldUtil.resolveName(queryEntity.getFieldFunc());
                Object value = queryEntity.getValue();
                if (queryType == QueryTypeEnum.EQ) {
                    queryWrapper.eq((Object)fieldName, value);
                    continue;
                }
                if (queryType == QueryTypeEnum.LIKE) {
                    queryWrapper.like((Object)fieldName, value);
                    continue;
                }
                if (queryType == QueryTypeEnum.OR) {
                    queryWrapper.or();
                    continue;
                }
                if (queryType == QueryTypeEnum.LE) {
                    queryWrapper.le((Object)fieldName, value);
                    continue;
                }
                if (queryType == QueryTypeEnum.GE) {
                    queryWrapper.ge((Object)fieldName, value);
                    continue;
                }
                if (queryType == QueryTypeEnum.LT) {
                    queryWrapper.lt((Object)fieldName, value);
                    continue;
                }
                if (queryType != QueryTypeEnum.GT) continue;
                queryWrapper.gt((Object)fieldName, value);
            }
        }
        if (orderByList != null) {
            for (OrderBy<R> orderBy : orderByList) {
                queryWrapper.orderBy(true, orderBy.isAsc(), (Object)orderBy.getColumn().getValue());
            }
        }
        return queryWrapper;
    }

    @NonNull
    protected abstract List<Query<R>> buildQueryEntity(@NonNull T var1);
}

