/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import top.isopen.commons.springboot.bean.OrderByRequest;
import top.isopen.commons.springboot.model.AbstractModel;
import top.isopen.commons.springboot.support.SFunction;
import top.isopen.commons.springboot.types.OrderBy;

public class OrderByList<T extends AbstractModel<T, ?>> {
    private final List<OrderBy<T>> orderByList;

    public OrderByList() {
        this.orderByList = new ArrayList<OrderBy<T>>();
    }

    public OrderByList(OrderBy<T> orderBy) {
        this();
        this.orderByList.add(orderBy);
    }

    @SafeVarargs
    public OrderByList(OrderBy<T> ... orderBys) {
        this(Arrays.stream(orderBys).collect(Collectors.toList()));
    }

    public OrderByList(List<OrderBy<T>> orderByList) {
        this.orderByList = orderByList;
    }

    public static <T extends AbstractModel<T, ?>> OrderByList<T> resolve(List<OrderByRequest> orderByRequestList) {
        return OrderByList.builder().orderByList(orderByRequestList.stream().map(OrderBy::resolve).collect(Collectors.toList())).build();
    }

    public OrderByList<T> asc(String column) {
        this.orderByList.add(new OrderBy().asc(column));
        return this;
    }

    public OrderByList<T> asc(SFunction<T, ?> func) {
        this.orderByList.add(new OrderBy<T>().asc(func));
        return this;
    }

    public OrderByList<T> desc(String column) {
        this.orderByList.add(new OrderBy().desc(column));
        return this;
    }

    public OrderByList<T> desc(SFunction<T, ?> func) {
        this.orderByList.add(new OrderBy<T>().desc(func));
        return this;
    }

    public static <T extends AbstractModel<T, ?>> OrderByListBuilder<T> builder() {
        return new OrderByListBuilder();
    }

    public List<OrderBy<T>> getOrderByList() {
        return this.orderByList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderByList)) {
            return false;
        }
        OrderByList other = (OrderByList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<OrderBy<T>> this$orderByList = this.getOrderByList();
        List<OrderBy<T>> other$orderByList = other.getOrderByList();
        return !(this$orderByList == null ? other$orderByList != null : !((Object)this$orderByList).equals(other$orderByList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderByList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<OrderBy<T>> $orderByList = this.getOrderByList();
        result = result * 59 + ($orderByList == null ? 43 : ((Object)$orderByList).hashCode());
        return result;
    }

    public String toString() {
        return "OrderByList(orderByList=" + this.getOrderByList() + ")";
    }

    public static class OrderByListBuilder<T extends AbstractModel<T, ?>> {
        private List<OrderBy<T>> orderByList;

        OrderByListBuilder() {
        }

        public OrderByListBuilder<T> orderByList(List<OrderBy<T>> orderByList) {
            this.orderByList = orderByList;
            return this;
        }

        public OrderByList<T> build() {
            return new OrderByList<T>(this.orderByList);
        }

        public String toString() {
            return "OrderByList.OrderByListBuilder(orderByList=" + this.orderByList + ")";
        }
    }
}

