/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import top.isopen.commons.springboot.model.AbstractModel;
import top.isopen.commons.springboot.repository.annotation.QueryField;
import top.isopen.commons.springboot.repository.enums.QueryTypeEnum;
import top.isopen.commons.springboot.repository.types.OrderBy;
import top.isopen.commons.springboot.repository.types.OrderByList;
import top.isopen.commons.springboot.repository.types.Query;
import top.isopen.commons.springboot.repository.types.QueryList;
import top.isopen.commons.springboot.types.AbstractType;
import top.isopen.commons.springboot.util.FieldUtil;
import top.isopen.commons.springboot.util.TypeUtil;

public abstract class AbstractRepository<T extends AbstractType<T, ?>, R extends AbstractModel<R, ?>> {
    @SafeVarargs
    protected final LambdaQueryWrapper<R> queryWrapper(T query, OrderBy<T> ... orderByList) {
        return this.queryWrapper(query, orderByList != null ? OrderByList.builder().orderBy(orderByList).build() : null);
    }

    protected LambdaQueryWrapper<R> queryWrapper(T query, OrderByList<T> orderByList) {
        return this.queryWrapper(query, orderByList != null ? orderByList.getValue() : null);
    }

    @SafeVarargs
    protected final LambdaQueryWrapper<R> queryWrapper(QueryList<T> queryList, OrderBy<T> ... orderByList) {
        return this.queryWrapper(queryList, orderByList != null ? OrderByList.builder().orderBy(orderByList).build() : null);
    }

    protected final LambdaQueryWrapper<R> queryWrapper(QueryList<T> queryList, OrderByList<T> orderByList) {
        return this.queryWrapper(queryList != null ? queryList.getValue() : null, orderByList != null ? orderByList.getValue() : null);
    }

    private LambdaQueryWrapper<R> queryWrapper(T query, List<OrderBy<T>> orderByList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (query != null) {
            List<Query<R>> queryList = this.resolveQuery(query);
            this.fillQuery(queryWrapper, queryList);
        }
        if (orderByList != null) {
            List<OrderBy<R>> transformedOrderByList = TypeUtil.transform(orderByList, orderBy -> OrderBy.builder().asc(orderBy.isAsc(), orderBy.getColumn()).build());
            this.fillOrderBy(queryWrapper, transformedOrderByList);
        }
        return queryWrapper.lambda();
    }

    private LambdaQueryWrapper<R> queryWrapper(List<Query<T>> queryList, List<OrderBy<T>> orderByList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (queryList != null) {
            List<Query<R>> transformedQueryList = TypeUtil.transform(queryList, query -> Query.builder().type(query.getType()).column(query.getColumn()).value(query.getValue()).build());
            this.fillQuery(queryWrapper, transformedQueryList);
        }
        if (orderByList != null) {
            List<OrderBy<R>> transformedOrderByList = TypeUtil.transform(orderByList, orderBy -> OrderBy.builder().asc(orderBy.isAsc(), orderBy.getColumn()).build());
            this.fillOrderBy(queryWrapper, transformedOrderByList);
        }
        return queryWrapper.lambda();
    }

    private List<Query<R>> resolveQuery(T query) {
        ArrayList<Query<R>> result = new ArrayList<Query<R>>();
        AbstractModel model = (AbstractModel)((AbstractType)query).toModel();
        Class<?> clazz = model.getClass();
        List<Field> fieldList = FieldUtil.resolveDeclaredField(clazz);
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(QueryField.class)) continue;
            field.setAccessible(true);
            Object value = field.get(model);
            if (value == null) continue;
            QueryField queryField = field.getAnnotation(QueryField.class);
            QueryTypeEnum type = queryField.type();
            result.add(Query.builder().type(type).column(field.getName()).value(value).build());
        }
        return result;
    }

    private void fillQuery(QueryWrapper<R> queryWrapper, List<Query<R>> queryList) {
        for (Query<R> queryEntity : queryList) {
            QueryTypeEnum queryType = queryEntity.getType();
            String column = queryEntity.getColumn();
            Object value = queryEntity.getValue();
            if (queryType == QueryTypeEnum.EQ) {
                queryWrapper.eq((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.LIKE) {
                queryWrapper.like((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.OR) {
                queryWrapper.or();
                continue;
            }
            if (queryType == QueryTypeEnum.NE) {
                queryWrapper.ne((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.LE) {
                queryWrapper.le((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.GE) {
                queryWrapper.ge((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.LT) {
                queryWrapper.lt((Object)column, value);
                continue;
            }
            if (queryType != QueryTypeEnum.GT) continue;
            queryWrapper.gt((Object)column, value);
        }
    }

    private void fillOrderBy(QueryWrapper<R> queryWrapper, List<OrderBy<R>> orderByList) {
        for (OrderBy<R> orderBy : orderByList) {
            queryWrapper.orderBy(true, orderBy.isAsc(), (Object)orderBy.getColumn());
        }
    }
}

