/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository.types;

import top.isopen.commons.springboot.repository.bean.OrderByRequest;
import top.isopen.commons.springboot.repository.support.SFunction;
import top.isopen.commons.springboot.repository.types.Column;
import top.isopen.commons.springboot.util.FieldUtil;
import top.isopen.commons.springboot.util.NameUtil;

public class OrderBy<T> {
    private SFunction<T, ?> columnFunc;
    private Column column;
    private boolean asc;

    public static <T> OrderBy<T> resolve(OrderByRequest orderByRequest) {
        return OrderBy.builder().asc(orderByRequest.isAsc(), orderByRequest.getColumn()).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public String getColumn() {
        return this.column.getValue();
    }

    public boolean isAsc() {
        return this.asc;
    }

    public String toString() {
        return "OrderBy{columnFunc=" + this.columnFunc + ", column=" + this.column.getValue() + ", asc=" + this.asc + '}';
    }

    public static class Builder<T> {
        private final OrderBy<T> orderBy = new OrderBy();

        Builder() {
        }

        public OrderBy<T> build() {
            return this.orderBy;
        }

        public Builder<T> asc(SFunction<T, ?> columnFunc) {
            ((OrderBy)this.orderBy).asc = true;
            ((OrderBy)this.orderBy).columnFunc = columnFunc;
            ((OrderBy)this.orderBy).column = new Column(FieldUtil.resolveName(columnFunc));
            return this;
        }

        public Builder<T> asc(String column) {
            ((OrderBy)this.orderBy).asc = true;
            ((OrderBy)this.orderBy).column = new Column(NameUtil.humpToUnderline(column));
            return this;
        }

        public Builder<T> asc(boolean asc, SFunction<T, ?> columnFunc) {
            ((OrderBy)this.orderBy).asc = asc;
            ((OrderBy)this.orderBy).columnFunc = columnFunc;
            ((OrderBy)this.orderBy).column = new Column(FieldUtil.resolveName(columnFunc));
            return this;
        }

        public Builder<T> asc(boolean asc, String column) {
            ((OrderBy)this.orderBy).asc = asc;
            ((OrderBy)this.orderBy).column = new Column(NameUtil.humpToUnderline(column));
            return this;
        }

        public Builder<T> desc(SFunction<T, ?> columnFunc) {
            ((OrderBy)this.orderBy).asc = false;
            ((OrderBy)this.orderBy).columnFunc = columnFunc;
            ((OrderBy)this.orderBy).column = new Column(FieldUtil.resolveName(columnFunc));
            return this;
        }

        public Builder<T> desc(String column) {
            ((OrderBy)this.orderBy).asc = false;
            ((OrderBy)this.orderBy).column = new Column(NameUtil.humpToUnderline(column));
            return this;
        }
    }
}

