/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository.types;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import top.isopen.commons.springboot.repository.bean.OrderByRequest;
import top.isopen.commons.springboot.repository.support.SFunction;
import top.isopen.commons.springboot.repository.types.OrderBy;

public class OrderByList<T> {
    private final List<OrderBy<T>> value = new ArrayList<OrderBy<T>>();

    private OrderByList() {
    }

    public static <T> OrderByList<T> resolve(List<OrderByRequest> orderByRequestList) {
        return OrderByList.builder().orderBy(orderByRequestList.stream().map(OrderBy::resolve).collect(Collectors.toList())).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public List<OrderBy<T>> getValue() {
        return this.value;
    }

    public static class Builder<T> {
        private final OrderByList<T> orderByList = new OrderByList();

        Builder() {
        }

        public OrderByList<T> build() {
            return this.orderByList;
        }

        public Builder<T> asc(SFunction<T, ?> columnFunc) {
            OrderBy orderBy = OrderBy.builder().asc(columnFunc).build();
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        public Builder<T> asc(String column) {
            OrderBy orderBy = OrderBy.builder().asc(column).build();
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        public Builder<T> asc(boolean asc, SFunction<T, ?> columnFunc) {
            OrderBy orderBy = OrderBy.builder().asc(asc, columnFunc).build();
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        public Builder<T> asc(boolean asc, String column) {
            OrderBy orderBy = OrderBy.builder().asc(asc, column).build();
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        public Builder<T> desc(SFunction<T, ?> columnFunc) {
            OrderBy orderBy = OrderBy.builder().desc(columnFunc).build();
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        public Builder<T> desc(String column) {
            OrderBy orderBy = OrderBy.builder().desc(column).build();
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        public Builder<T> orderBy(OrderBy<T> orderBy) {
            this.orderByList.getValue().add(orderBy);
            return this;
        }

        @SafeVarargs
        public final Builder<T> orderBy(OrderBy<T> ... orderByList) {
            for (OrderBy<T> orderBy : orderByList) {
                this.orderByList.getValue().add(orderBy);
            }
            return this;
        }

        public Builder<T> orderBy(List<OrderBy<T>> orderByList) {
            this.orderByList.getValue().addAll(orderByList);
            return this;
        }
    }
}

