/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository.types;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import top.isopen.commons.springboot.repository.bean.QueryRequest;
import top.isopen.commons.springboot.repository.types.Query;

public class QueryList<T> {
    private final List<Query<T>> value = new ArrayList<Query<T>>();

    private QueryList() {
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> QueryList<T> resolve(List<QueryRequest> queryRequestList) {
        return QueryList.builder().query(queryRequestList.stream().map(Query::resolve).collect(Collectors.toList())).build();
    }

    public List<Query<T>> getValue() {
        return this.value;
    }

    public static class Builder<T> {
        private final QueryList<T> queryList = new QueryList();

        Builder() {
        }

        public QueryList<T> build() {
            return this.queryList;
        }

        @SafeVarargs
        public final Builder<T> query(Query<T> ... queryList) {
            for (Query<T> query : queryList) {
                this.queryList.getValue().add(query);
            }
            return this;
        }

        public Builder<T> query(List<Query<T>> queryList) {
            this.queryList.getValue().addAll(queryList);
            return this;
        }
    }
}

