/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.model.AbstractModel;
import top.isopen.commons.springboot.repository.annotation.OrderByField;
import top.isopen.commons.springboot.repository.annotation.QueryField;
import top.isopen.commons.springboot.repository.enums.OrderByTypeEnum;
import top.isopen.commons.springboot.repository.enums.QueryTypeEnum;
import top.isopen.commons.springboot.repository.types.OrderBy;
import top.isopen.commons.springboot.repository.types.OrderByList;
import top.isopen.commons.springboot.repository.types.Query;
import top.isopen.commons.springboot.repository.types.QueryList;
import top.isopen.commons.springboot.types.AbstractType;
import top.isopen.commons.springboot.util.FieldUtil;
import top.isopen.commons.springboot.util.TypeUtil;

public abstract class AbstractRepository<T extends AbstractType<T, ?>, R extends AbstractModel<R, ?>> {
    private static final Log log = LogFactory.getLog(AbstractRepository.class);

    protected final LambdaQueryWrapper<R> queryWrapper(T query, boolean inOrder) {
        AbstractModel model = query != null ? (AbstractModel)((AbstractType)query).toModel() : null;
        Class<?> clazz = model != null ? model.getClass() : null;
        List<Field> fieldList = clazz != null ? FieldUtil.resolveDeclaredField(clazz) : null;
        List<Query<R>> queryList = fieldList != null ? this.resolveQuery(model, fieldList) : null;
        List<OrderBy<R>> orderByList = inOrder && fieldList != null ? this.resolveOrderBy(fieldList) : null;
        return this.queryWrapper(queryList, orderByList);
    }

    @SafeVarargs
    protected final LambdaQueryWrapper<R> queryWrapper(T query, OrderBy<T> ... orderByList) {
        return this.queryWrapper(query, orderByList != null ? OrderByList.builder().orderBy(orderByList).build() : null);
    }

    protected LambdaQueryWrapper<R> queryWrapper(T query, OrderByList<T> orderByList) {
        AbstractModel model = query != null ? (AbstractModel)((AbstractType)query).toModel() : null;
        Class<?> clazz = model != null ? model.getClass() : null;
        List<Field> fieldList = clazz != null ? FieldUtil.resolveDeclaredField(clazz) : null;
        List<Query<R>> queryList = fieldList != null ? this.resolveQuery(model, fieldList) : null;
        List<OrderBy<R>> transformedOrderByList = orderByList != null ? TypeUtil.transform(orderByList.getValue(), orderBy -> OrderBy.builder().asc(orderBy.isAsc(), orderBy.getColumn()).build()) : null;
        return this.queryWrapper(queryList, transformedOrderByList);
    }

    @SafeVarargs
    protected final LambdaQueryWrapper<R> queryWrapper(QueryList<T> queryList, OrderBy<T> ... orderByList) {
        return this.queryWrapper(queryList, orderByList != null ? OrderByList.builder().orderBy(orderByList).build() : null);
    }

    protected final LambdaQueryWrapper<R> queryWrapper(QueryList<T> queryList, OrderByList<T> orderByList) {
        List<Query<R>> transformedQueryList = queryList != null ? TypeUtil.transform(queryList.getValue(), query -> Query.builder().type(query.getType()).column(query.getColumn()).value(query.getValue()).build()) : null;
        List<OrderBy<R>> transformedOrderByList = orderByList != null ? TypeUtil.transform(orderByList.getValue(), orderBy -> OrderBy.builder().asc(orderBy.isAsc(), orderBy.getColumn()).build()) : null;
        return this.queryWrapper(transformedQueryList, transformedOrderByList);
    }

    private LambdaQueryWrapper<R> queryWrapper(List<Query<R>> queryList, List<OrderBy<R>> orderByList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (queryList != null) {
            this.fillQuery(queryWrapper, queryList);
        }
        if (orderByList != null) {
            this.fillOrderBy(queryWrapper, orderByList);
        }
        return queryWrapper.lambda();
    }

    private List<Query<R>> resolveQuery(R model, List<Field> fieldList) {
        ArrayList<Query<R>> result = new ArrayList<Query<R>>();
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(QueryField.class)) continue;
            field.setAccessible(true);
            Object value = field.get(model);
            if (value == null) continue;
            QueryField queryField = field.getAnnotation(QueryField.class);
            QueryTypeEnum type = queryField.type();
            result.add(Query.builder().type(type).column(field.getName()).value(value).build());
        }
        return result;
    }

    private List<OrderBy<R>> resolveOrderBy(List<Field> fieldList) {
        ArrayList<OrderBy<R>> result = new ArrayList<OrderBy<R>>();
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(OrderByField.class)) continue;
            OrderByField orderByField = field.getAnnotation(OrderByField.class);
            OrderByTypeEnum type = orderByField.type();
            int order = orderByField.order();
            result.add(OrderBy.builder().asc(type.isAsc(), field.getName(), order).build());
        }
        return result;
    }

    private void fillQuery(QueryWrapper<R> queryWrapper, List<Query<R>> queryList) {
        for (Query<R> queryEntity : queryList) {
            QueryTypeEnum queryType = queryEntity.getType();
            String column = this.escapeColumn(queryEntity.getColumn());
            Object value = queryEntity.getValue();
            if (log.isDebugEnabled()) {
                log.info("query type: {}, column: {}, value: {}", new Object[]{queryType, column, value});
            }
            if (queryType == QueryTypeEnum.EQ) {
                queryWrapper.eq((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.LIKE) {
                queryWrapper.like((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.OR) {
                queryWrapper.or();
                continue;
            }
            if (queryType == QueryTypeEnum.NE) {
                queryWrapper.ne((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.LE) {
                queryWrapper.le((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.GE) {
                queryWrapper.ge((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.LT) {
                queryWrapper.lt((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.GT) {
                queryWrapper.gt((Object)column, value);
                continue;
            }
            if (queryType == QueryTypeEnum.IN) {
                queryWrapper.in((Object)column, (Collection)((List)value));
                continue;
            }
            if (queryType != QueryTypeEnum.NOT_IN) continue;
            queryWrapper.notIn((Object)column, (Collection)((List)value));
        }
    }

    private void fillOrderBy(QueryWrapper<R> queryWrapper, List<OrderBy<R>> orderByList) {
        orderByList.sort(Comparator.comparingInt(OrderBy::getOrder));
        for (OrderBy<R> orderBy : orderByList) {
            if (log.isDebugEnabled()) {
                log.info("order by column: {} {}, order: {}", new Object[]{orderBy.getColumn(), orderBy.isAsc(), orderBy.getOrder()});
            }
            queryWrapper.orderBy(true, orderBy.isAsc(), (Object)this.escapeColumn(orderBy.getColumn()));
        }
    }

    private String escapeColumn(String column) {
        return "`" + column + "`";
    }
}

