/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository.enums;

import top.isopen.commons.springboot.enums.BaseErrorEnum;

public enum OrderByTypeEnum {
    ASC("asc", "\u6b63\u5e8f"),
    DESC("desc", "\u9006\u5e8f");

    private static final OrderByTypeEnum[] VALUES;
    private final String value;
    private final String description;

    private OrderByTypeEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static OrderByTypeEnum resolve(String value) {
        String valueLowerCase = value.toLowerCase();
        for (OrderByTypeEnum orderByTypeEnum : VALUES) {
            if (!orderByTypeEnum.value.equals(valueLowerCase)) continue;
            return orderByTypeEnum;
        }
        BaseErrorEnum.INVALID_ORDER_BY_TYPE_ERROR.throwException();
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAsc() {
        return this.equals((Object)ASC);
    }

    static {
        VALUES = OrderByTypeEnum.values();
    }
}

