/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository.types;

import top.isopen.commons.springboot.repository.bean.QueryRequest;
import top.isopen.commons.springboot.repository.enums.QueryTypeEnum;
import top.isopen.commons.springboot.repository.support.SFunction;
import top.isopen.commons.springboot.repository.types.Column;
import top.isopen.commons.springboot.util.FieldUtil;
import top.isopen.commons.springboot.util.NameUtil;

public class Query<T> {
    private static final String COLUMN_PLACEHOLDER = "UNKNOWN_COLUMN";
    private QueryTypeEnum type;
    private SFunction<T, ?> columnFunc;
    private Column column;
    private Object value;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Query<T> resolve(QueryRequest queryRequest) {
        return Query.builder().type(QueryTypeEnum.resolve(queryRequest.getType())).column(queryRequest.getColumn()).value(queryRequest.getValue()).build();
    }

    public QueryTypeEnum getType() {
        return this.type;
    }

    public String getColumn() {
        return this.column.getValue();
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "Query{type=" + (Object)((Object)this.type) + ", columnFunc=" + this.columnFunc + ", column='" + this.column.getValue() + '\'' + ", value=" + this.value + '}';
    }

    public static class Builder<T> {
        private final Query<T> query = new Query();

        Builder() {
        }

        public Query<T> build() {
            return this.query;
        }

        public Builder<T> type(QueryTypeEnum type) {
            ((Query)this.query).type = type;
            return this;
        }

        public Builder<T> columnFunc(SFunction<T, ?> columnFunc) {
            ((Query)this.query).columnFunc = columnFunc;
            ((Query)this.query).column = new Column(FieldUtil.resolveName(columnFunc));
            return this;
        }

        public Builder<T> column(String column) {
            ((Query)this.query).column = new Column(column == null || column.length() == 0 ? Query.COLUMN_PLACEHOLDER : NameUtil.humpToUnderline(column));
            return this;
        }

        public Builder<T> value(Object value) {
            ((Query)this.query).value = value;
            return this;
        }
    }
}

