/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.helper;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.enums.BaseErrorEnum;

public class RedisHelper {
    public final long DEFAULT_LOCK_TIMEOUT = 3L;
    public final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final Log log = LogFactory.getLog(RedisHelper.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final String RELEASE_LOCK_LUA;

    public RedisHelper(RedisTemplate<String, Object> redisTemplate) {
        this.RELEASE_LOCK_LUA = "if redis.call('get',KEYS[1]) == ARGV[1] then     return redis.call('del',KEYS[1]) else     return 0 end ";
        this.redisTemplate = redisTemplate;
    }

    public boolean delete(String key) {
        Boolean result = this.redisTemplate.delete((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("delete(...) => key -> {}", new Object[]{key});
            this.log.debug("delete(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long delete(Collection<String> keys) {
        Long count = this.redisTemplate.delete(keys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("delete(...) => keys -> {}", new Object[]{keys});
            this.log.debug("delete(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public byte[] dump(String key) {
        byte[] result = this.redisTemplate.dump((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("dump(...) => key -> {}", new Object[]{key});
            this.log.debug("dump(...) => result -> {}", new Object[]{Arrays.toString(result)});
        }
        return result;
    }

    public void restore(String key, byte[] value, long timeToLive, TimeUnit unit) {
        this.restore(key, value, timeToLive, unit, false);
    }

    public void restore(String key, byte[] value, long timeToLive, TimeUnit unit, boolean replace) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("restore(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}, replace -> {}", new Object[]{key, value, timeToLive, unit, replace});
        }
        this.redisTemplate.restore((Object)key, value, timeToLive, unit, replace);
    }

    public boolean hasKey(String key) {
        Boolean result = this.redisTemplate.hasKey((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hasKey(...) => key -> {}", new Object[]{key});
            this.log.debug("hasKey(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean expire(String key, long timeToLive, TimeUnit unit) {
        Boolean result = this.redisTemplate.expire((Object)key, timeToLive, unit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("expire(...) => key -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, timeToLive, unit});
            this.log.debug("expire(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean expireAt(String key, Date date) {
        Boolean result = this.redisTemplate.expireAt((Object)key, date);
        if (this.log.isDebugEnabled()) {
            this.log.debug("expireAt(...) => key -> {}, date -> {}", new Object[]{key, date});
            this.log.debug("expireAt(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public Set<String> keys(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (this.log.isDebugEnabled()) {
            this.log.debug("keys(...) => pattern -> {}", new Object[]{pattern});
            this.log.debug("keys(...) => keys -> {}", new Object[]{keys});
        }
        return keys;
    }

    public boolean move(String key, int dbIndex) {
        Boolean result = this.redisTemplate.move((Object)key, dbIndex);
        if (this.log.isDebugEnabled()) {
            this.log.debug("move(...) => key  -> {}, dbIndex -> {}", new Object[]{key, dbIndex});
            this.log.debug("move(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean persist(String key) {
        Boolean result = this.redisTemplate.persist((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("persist(...) => key -> {}", new Object[]{key});
            this.log.debug("persist(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long getExpire(String key) {
        return this.getExpire(key, TimeUnit.SECONDS);
    }

    public long getExpire(String key, TimeUnit unit) {
        Long result = this.redisTemplate.getExpire((Object)key, unit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("getExpire(...) => key -> {}, unit is -> {}", new Object[]{key, unit});
            this.log.debug("getExpire(...) => result ->  {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public String randomKey() {
        String result = (String)this.redisTemplate.randomKey();
        if (this.log.isDebugEnabled()) {
            this.log.debug("randomKey(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public void rename(String oldKey, String newKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("rename(...) => oldKey -> {}, newKey -> {}", new Object[]{oldKey, newKey});
        }
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public boolean renameIfAbsent(String oldKey, String newKey) {
        Boolean result = this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("renameIfAbsent(...) => oldKey -> {}, newKey -> {}", new Object[]{oldKey, newKey});
            this.log.debug("renameIfAbsent(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public DataType type(String key) {
        DataType result = this.redisTemplate.type((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("type(...) => key -> {}", new Object[]{key});
            this.log.debug("type(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public void set(String key, Object value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("set(...) => key -> {}, value -> {}", new Object[]{key, value});
        }
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public boolean setBit(String key, long offset, boolean value) {
        Boolean result = this.redisTemplate.opsForValue().setBit((Object)key, offset, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setBit(...) => key -> {}, offset -> {}, value -> {}", new Object[]{key, offset, value});
            this.log.debug("setBit(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public void setEx(String key, Object value, long timeToLive, TimeUnit unit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setEx(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, value, timeToLive, unit});
        }
        this.redisTemplate.opsForValue().set((Object)key, value, timeToLive, unit);
    }

    public boolean setIfAbsent(String key, Object value) {
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setIfAbsent(...) => key -> {}, value -> {}", new Object[]{key, value});
            this.log.debug("setIfAbsent(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean setIfAbsent(String key, Object value, long timeToLive, TimeUnit unit) {
        Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, value, timeToLive, unit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("setIfAbsent(...) => key -> {}, value -> {}, timeToLive -> {}, unit -> {}", new Object[]{key, value, timeToLive, unit});
            this.log.debug("setIfAbsent(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public void setRange(String key, String replaceValue, long offset) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setRange(...) => key -> {}, replaceValue -> {}, offset -> {}", new Object[]{key, replaceValue, offset});
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)replaceValue, offset);
    }

    public long size(String key) {
        Long result = this.redisTemplate.opsForValue().size((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("size(...) => key -> {}", new Object[]{key});
            this.log.debug("size(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public void multiSet(Map<String, Object> maps) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("multiSet(...) => maps -> {}", new Object[]{maps});
        }
        this.redisTemplate.opsForValue().multiSet(maps);
    }

    public boolean multiSetIfAbsent(Map<String, Object> maps) {
        Boolean result = this.redisTemplate.opsForValue().multiSetIfAbsent(maps);
        if (this.log.isDebugEnabled()) {
            this.log.debug("multiSetIfAbsent(...) => maps -> {}", new Object[]{maps});
            this.log.debug("multiSetIfAbsent(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long incrBy(String key, long increment) {
        Long result = this.redisTemplate.opsForValue().increment((Object)key, increment);
        if (this.log.isDebugEnabled()) {
            this.log.debug("incrBy(...) => key -> {}, increment -> {}", new Object[]{key, increment});
            this.log.debug("incrBy(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public double incrByFloat(String key, double increment) {
        Double result = this.redisTemplate.opsForValue().increment((Object)key, increment);
        if (this.log.isDebugEnabled()) {
            this.log.debug("incrByFloat(...) => key -> {}, increment -> {}", new Object[]{key, increment});
            this.log.debug("incrByFloat(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public int append(String key, String value) {
        Integer result = this.redisTemplate.opsForValue().append((Object)key, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug("append(...) => key -> {}, value -> {}", new Object[]{key, value});
            this.log.debug("append(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public Object get(String key) {
        Object result = this.redisTemplate.opsForValue().get((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("get(...) => key -> {}", new Object[]{key});
            this.log.debug("get(...) => result -> {} ", new Object[]{result});
        }
        return result;
    }

    public String getRange(String key, long start, long end) {
        String result = this.redisTemplate.opsForValue().get((Object)key, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug("getRange(...) => key -> {}", new Object[]{key});
            this.log.debug("getRange(...) => result -> {} ", new Object[]{result});
        }
        return result;
    }

    public Object getAndSet(String key, Object newValue) {
        Object oldValue = this.redisTemplate.opsForValue().getAndSet((Object)key, newValue);
        if (this.log.isDebugEnabled()) {
            this.log.debug("getAndSet(...) => key -> {}, value -> {}", new Object[]{key, newValue});
            this.log.debug("getAndSet(...) => oldValue -> {}", new Object[]{oldValue});
        }
        return oldValue;
    }

    public boolean getBit(String key, long offset) {
        Boolean result = this.redisTemplate.opsForValue().getBit((Object)key, offset);
        if (this.log.isDebugEnabled()) {
            this.log.debug("getBit(...) => key -> {}, offset -> {}", new Object[]{key, offset});
            this.log.debug("getBit(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public List<Object> multiGet(Collection<String> keys) {
        List result = this.redisTemplate.opsForValue().multiGet(keys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("multiGet(...) => keys -> {}", new Object[]{keys});
            this.log.debug("multiGet(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public void hPut(String key, String entryKey, Object entryValue) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("hPut(...) => key -> {}, entryKey -> {}, entryValue -> {}", new Object[]{key, entryKey, entryValue});
        }
        this.redisTemplate.opsForHash().put((Object)key, (Object)entryKey, entryValue);
    }

    public void hPutAll(String key, Map<String, Object> maps) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("hPutAll(...) => key -> {}, maps -> {}", new Object[]{key, maps});
        }
        this.redisTemplate.opsForHash().putAll((Object)key, maps);
    }

    public boolean hPutIfAbsent(String key, String entryKey, Object entryValue) {
        Boolean result = this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)entryKey, entryValue);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hPutIfAbsent(...) => key -> {}, entryKey -> {}, entryValue -> {}", new Object[]{key, entryKey, entryValue});
            this.log.debug("hPutIfAbsent(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public Object hGet(String key, String entryKey) {
        Object entryValue = this.redisTemplate.opsForHash().get((Object)key, (Object)entryKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hGet(...) => key -> {}, entryKey -> {}", new Object[]{key, entryKey});
            this.log.debug("hGet(...) => entryValue -> {}", new Object[]{entryValue});
        }
        return entryValue;
    }

    public Map<Object, Object> hGetAll(String key) {
        Map result = this.redisTemplate.opsForHash().entries((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hGetAll(...) => key -> {}", new Object[]{key});
            this.log.debug("hGetAll(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public List<Object> hMultiGet(String key, Collection<Object> entryKeys) {
        List entryValues = this.redisTemplate.opsForHash().multiGet((Object)key, entryKeys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hMultiGet(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKeys});
            this.log.debug("hMultiGet(...) => entryValues -> {}", new Object[]{entryValues});
        }
        return entryValues;
    }

    public long hDelete(String key, Object ... entryKeys) {
        Long count = this.redisTemplate.opsForHash().delete((Object)key, entryKeys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hDelete(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKeys});
            this.log.debug("hDelete(...) => count -> {}", new Object[]{count});
        }
        return count;
    }

    public boolean hExists(String key, String entryKey) {
        Boolean exist = this.redisTemplate.opsForHash().hasKey((Object)key, (Object)entryKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hDelete(...) => key -> {}, entryKeys -> {}", new Object[]{key, entryKey});
            this.log.debug("hDelete(...) => exist -> {}", new Object[]{exist});
        }
        return exist;
    }

    public long hIncrBy(String key, Object entryKey, long increment) {
        Long result = this.redisTemplate.opsForHash().increment((Object)key, entryKey, increment);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hIncrBy(...) => key -> {}, entryKey -> {}, increment -> {}", new Object[]{key, entryKey, increment});
            this.log.debug("hIncrBy(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public double hIncrByFloat(String key, Object entryKey, double increment) {
        Double result = this.redisTemplate.opsForHash().increment((Object)key, entryKey, increment);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hIncrByFloat(...) => key -> {}, entryKey -> {}, increment -> {}", new Object[]{key, entryKey, increment});
            this.log.debug("hIncrByFloat(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public Set<Object> hKeys(String key) {
        Set entryKeys = this.redisTemplate.opsForHash().keys((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hKeys(...) => key -> {}", new Object[]{key});
            this.log.debug("hKeys(...) => entryKeys -> {}", new Object[]{entryKeys});
        }
        return entryKeys;
    }

    public List<Object> hValues(String key) {
        List entryValues = this.redisTemplate.opsForHash().values((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hValues(...) => key -> {}", new Object[]{key});
            this.log.debug("hValues(...) => entryValues -> {}", new Object[]{entryValues});
        }
        return entryValues;
    }

    public long hSize(String key) {
        Long count = this.redisTemplate.opsForHash().size((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hSize(...) => key -> {}", new Object[]{key});
            this.log.debug("hSize(...) => count -> {}", new Object[]{count});
        }
        return count;
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
        Cursor cursor = this.redisTemplate.opsForHash().scan((Object)key, options);
        if (this.log.isDebugEnabled()) {
            this.log.debug("hScan(...) => key -> {}, options -> {}", new Object[]{key, JSON.toJSONString((Object)options)});
            this.log.debug("hScan(...) => cursor -> {}", new Object[]{JSON.toJSONString((Object)cursor)});
        }
        return cursor;
    }

    public long lLeftPush(String key, Object value) {
        Long size = this.redisTemplate.opsForList().leftPush((Object)key, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPush(...) => key -> {}, item -> {}", new Object[]{key, value});
            this.log.debug("lLeftPush(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPushAll(String key, Object ... items) {
        Long size = this.redisTemplate.opsForList().leftPushAll((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("lLeftPushAll(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPushAll(String key, Collection<Object> items) {
        Long size = this.redisTemplate.opsForList().leftPushAll((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("lLeftPushAll(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPushIfPresent(String key, Object item) {
        Long size = this.redisTemplate.opsForList().leftPushIfPresent((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPushIfPresent(...) => key -> {}, item -> {}", new Object[]{key, item});
            this.log.debug("lLeftPushIfPresent(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lLeftPush(String key, String pivot, Object item) {
        Long size = this.redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPush(...) => key -> {}, pivot -> {}, item -> {}", new Object[]{key, pivot, item});
            this.log.debug("lLeftPush(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPush(String key, Object item) {
        Long size = this.redisTemplate.opsForList().rightPush((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPush(...) => key -> {}, item -> {}", new Object[]{key, item});
            this.log.debug("lRightPush(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPushAll(String key, Object ... items) {
        Long size = this.redisTemplate.opsForList().rightPushAll((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("lRightPushAll(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPushAll(String key, Collection<Object> items) {
        Long size = this.redisTemplate.opsForList().rightPushAll((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPushAll(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("lRightPushAll(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPushIfPresent(String key, Object item) {
        Long size = this.redisTemplate.opsForList().rightPushIfPresent((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPushIfPresent(...) => key -> {}, item -> {}", new Object[]{key, item});
            this.log.debug("lRightPushIfPresent(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRightPush(String key, String pivot, Object item) {
        Long size = this.redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPush(...) => key -> {}, pivot -> {}, item -> {}", new Object[]{key, pivot, item});
            this.log.debug("lLeftPush(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Object lLeftPop(String key) {
        Object item = this.redisTemplate.opsForList().leftPop((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPop(...) => key -> {}", new Object[]{key});
            this.log.debug("lLeftPop(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public Object lLeftPop(String key, long timeout, TimeUnit unit) {
        Object item = this.redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lLeftPop(...) => key -> {}, timeout -> {}, unit -> {}", new Object[]{key, timeout, unit});
            this.log.debug("lLeftPop(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public Object lRightPop(String key) {
        Object item = this.redisTemplate.opsForList().rightPop((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPop(...) => key -> {}", new Object[]{key});
            this.log.debug("lRightPop(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public Object lRightPop(String key, long timeout, TimeUnit unit) {
        Object item = this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPop(...) => key -> {}, timeout -> {}, unit -> {}", new Object[]{key, timeout, unit});
            this.log.debug("lRightPop(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public Object lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        Object item = this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPopAndLeftPush(...) => sourceKey -> {}, destinationKey -> {}", new Object[]{sourceKey, destinationKey});
            this.log.debug("lRightPopAndLeftPush(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public Object lRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        Object item = this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRightPopAndLeftPush(...) => sourceKey -> {}, destinationKey -> {}, timeout -> {}, unit -> {}", new Object[]{sourceKey, destinationKey, timeout, unit});
            this.log.debug("lRightPopAndLeftPush(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public void lSet(String key, long index, Object item) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("lSet(...) => key -> {}, index -> {}, item -> {}", new Object[]{key, index, item});
        }
        this.redisTemplate.opsForList().set((Object)key, index, item);
    }

    public Object lIndex(String key, long index) {
        Object item = this.redisTemplate.opsForList().index((Object)key, index);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lIndex(...) => key -> {}, index -> {}", new Object[]{key, index});
            this.log.debug("lIndex(...) => item -> {}", new Object[]{item});
        }
        return item;
    }

    public List<Object> lRange(String key, long start, long end) {
        List result = this.redisTemplate.opsForList().range((Object)key, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            this.log.debug("lRange(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public List<Object> lWholeList(String key) {
        List result = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lWholeList(...) => key -> {}", new Object[]{key});
            this.log.debug("lWholeList(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public long lSize(String key) {
        Long size = this.redisTemplate.opsForList().size((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lSize(...) => key -> {}", new Object[]{key});
            this.log.debug("lSize(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long lRemove(String key, long expectCount, Object item) {
        Long actualCount = this.redisTemplate.opsForList().remove((Object)key, expectCount, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("lRemove(...) => key -> {}, expectCount -> {}, item -> {}", new Object[]{key, expectCount, item});
            this.log.debug("lRemove(...) => actualCount -> {}", new Object[]{actualCount});
        }
        if (actualCount == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return actualCount;
    }

    public void lTrim(String key, long start, long end) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("lTrim(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
        }
        this.redisTemplate.opsForList().trim((Object)key, start, end);
    }

    public long sAdd(String key, Object ... items) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sAdd(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("sAdd(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long sRemove(String key, Object ... items) {
        Long count = this.redisTemplate.opsForSet().remove((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sRemove(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("sRemove(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public Object sPop(String key) {
        Object popItem = this.redisTemplate.opsForSet().pop((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sPop(...) => key -> {}", new Object[]{key});
            this.log.debug("sPop(...) => popItem -> {}", new Object[]{popItem});
        }
        return popItem;
    }

    public boolean sMove(String sourceKey, Object item, String destinationKey) {
        Boolean result = this.redisTemplate.opsForSet().move((Object)sourceKey, item, (Object)destinationKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sMove(...) => sourceKey -> {}, destinationKey -> {}, item -> {}", new Object[]{sourceKey, destinationKey, item});
            this.log.debug("sMove(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long sSize(String key) {
        Long size = this.redisTemplate.opsForSet().size((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sSize(...) => key -> {}", new Object[]{key});
            this.log.debug("sSize(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public boolean sIsMember(String key, Object item) {
        Boolean result = this.redisTemplate.opsForSet().isMember((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sSize(...) => key -> {}, size -> {}", new Object[]{key, item});
            this.log.debug("sSize(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public Set<Object> sIntersect(String key, String otherKey) {
        Set intersectResult = this.redisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sIntersect(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
            this.log.debug("sIntersect(...) => intersectResult -> {}", new Object[]{intersectResult});
        }
        return intersectResult;
    }

    public Set<Object> sIntersect(String key, Collection<String> otherKeys) {
        Set intersectResult = this.redisTemplate.opsForSet().intersect((Object)key, otherKeys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sIntersect(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
            this.log.debug("sIntersect(...) => intersectResult -> {}", new Object[]{intersectResult});
        }
        return intersectResult;
    }

    public long sIntersectAndStore(String key, String otherKey, String storeKey) {
        Long size = this.redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sIntersectAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            this.log.debug("sIntersectAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long sIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
        Long size = this.redisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sIntersectAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            this.log.debug("sIntersectAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Set<Object> sUnion(String key, String otherKey) {
        Set unionResult = this.redisTemplate.opsForSet().union((Object)key, (Object)otherKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sUnion(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
            this.log.debug("sUnion(...) => unionResult -> {}", new Object[]{unionResult});
        }
        return unionResult;
    }

    public Set<Object> sUnion(String key, Collection<String> otherKeys) {
        Set unionResult = this.redisTemplate.opsForSet().union((Object)key, otherKeys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sUnion(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
            this.log.debug("sUnion(...) => unionResult -> {}", new Object[]{unionResult});
        }
        return unionResult;
    }

    public long sUnionAndStore(String key, String otherKey, String storeKey) {
        Long size = this.redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sUnionAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            this.log.debug("sUnionAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long sUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
        Long size = this.redisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sUnionAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            this.log.debug("sUnionAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Set<Object> sDifference(String key, String otherKey) {
        Set differenceResult = this.redisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sDifference(...) => key -> {}, otherKey -> {}", new Object[]{key, otherKey});
            this.log.debug("sDifference(...) => differenceResult -> {}", new Object[]{differenceResult});
        }
        return differenceResult;
    }

    public Set<Object> sDifference(String key, Collection<String> otherKeys) {
        Set differenceResult = this.redisTemplate.opsForSet().difference((Object)key, otherKeys);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sDifference(...) => key -> {}, otherKeys -> {}", new Object[]{key, otherKeys});
            this.log.debug("sDifference(...) => differenceResult -> {}", new Object[]{differenceResult});
        }
        return differenceResult;
    }

    public long sDifferenceAndStore(String key, String otherKey, String storeKey) {
        Long size = this.redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sDifferenceAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            this.log.debug("sDifferenceAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long sDifferenceAndStore(String key, Collection<String> otherKeys, String storeKey) {
        Long size = this.redisTemplate.opsForSet().differenceAndStore((Object)key, otherKeys, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sDifferenceAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            this.log.debug("sDifferenceAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public Set<Object> sMembers(String key) {
        Set members = this.redisTemplate.opsForSet().members((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sMembers(...) => key -> {}", new Object[]{key});
            this.log.debug("sMembers(...) => members -> {}", new Object[]{members});
        }
        return members;
    }

    public Object sRandomMember(String key) {
        Object randomItem = this.redisTemplate.opsForSet().randomMember((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sRandomMember(...) => key -> {}", new Object[]{key});
            this.log.debug("sRandomMember(...) => randomItem -> {}", new Object[]{randomItem});
        }
        return randomItem;
    }

    public List<Object> sRandomMembers(String key, long count) {
        List randomItems = this.redisTemplate.opsForSet().randomMembers((Object)key, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sRandomMembers(...) => key -> {}, count -> {}", new Object[]{key, count});
            this.log.debug("sRandomMembers(...) => randomItems -> {}", new Object[]{randomItems});
        }
        return randomItems;
    }

    public Set<Object> sDistinctRandomMembers(String key, long count) {
        Set distinctRandomItems = this.redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sDistinctRandomMembers(...) => key -> {}, count -> {}", new Object[]{key, count});
            this.log.debug("sDistinctRandomMembers(...) => distinctRandomItems -> {}", new Object[]{distinctRandomItems});
        }
        return distinctRandomItems;
    }

    public Cursor<Object> sScan(String key, ScanOptions options) {
        Cursor cursor = this.redisTemplate.opsForSet().scan((Object)key, options);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sScan(...) => key -> {}, options -> {}", new Object[]{key, JSON.toJSONString((Object)options)});
            this.log.debug("sScan(...) => cursor -> {}", new Object[]{JSON.toJSONString((Object)cursor)});
        }
        return cursor;
    }

    public boolean zAdd(String key, Object item, double score) {
        Boolean result = this.redisTemplate.opsForZSet().add((Object)key, item, score);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zAdd(...) => key -> {}, item -> {}, score -> {}", new Object[]{key, item, score});
            this.log.debug("zAdd(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public long zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> entries) {
        Long count = this.redisTemplate.opsForZSet().add((Object)key, entries);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zAdd(...) => key -> {}, entries -> {}", new Object[]{key, JSON.toJSONString(entries)});
            this.log.debug("zAdd(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zRemove(String key, Object ... items) {
        Long count = this.redisTemplate.opsForZSet().remove((Object)key, items);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRemove(...) => key -> {}, items -> {}", new Object[]{key, items});
            this.log.debug("zRemove(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zRemoveRange(String key, long startRange, long endRange) {
        Long count = this.redisTemplate.opsForZSet().removeRange((Object)key, startRange, endRange);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRemoveRange(...) => key -> {}, startRange -> {}, endRange -> {}", new Object[]{key, startRange, endRange});
            this.log.debug("zRemoveRange(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zRemoveRangeByScore(String key, double minScore, double maxScore) {
        Long count = this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, minScore, maxScore);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRemoveRangeByScore(...) => key -> {}, startIndex -> {}, startIndex -> {}", new Object[]{key, minScore, maxScore});
            this.log.debug("zRemoveRangeByScore(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public double zIncrementScore(String key, Object item, double delta) {
        Double scoreValue = this.redisTemplate.opsForZSet().incrementScore((Object)key, item, delta);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zIncrementScore(...) => key -> {}, item -> {}, delta -> {}", new Object[]{key, item, delta});
            this.log.debug("zIncrementScore(...) => scoreValue -> {}", new Object[]{scoreValue});
        }
        if (scoreValue == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return scoreValue;
    }

    public long zRank(String key, Object item) {
        Long rank = this.redisTemplate.opsForZSet().rank((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRank(...) => key -> {}, item -> {}", new Object[]{key, item});
            this.log.debug("zRank(...) => rank -> {}", new Object[]{rank});
        }
        if (rank == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return rank;
    }

    public long zReverseRank(String key, Object item) {
        Long reverseRank = this.redisTemplate.opsForZSet().reverseRank((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zReverseRank(...) => key -> {}, item -> {}", new Object[]{key, item});
            this.log.debug("zReverseRank(...) => reverseRank -> {}", new Object[]{reverseRank});
        }
        if (reverseRank == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return reverseRank;
    }

    public Set<Object> zRange(String key, long start, long end) {
        Set result = this.redisTemplate.opsForZSet().range((Object)key, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            this.log.debug("zRange(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public Set<Object> zWholeZSetItem(String key) {
        Set result = this.redisTemplate.opsForZSet().range((Object)key, 0L, -1L);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zWholeZSetItem(...) => key -> {}", new Object[]{key});
            this.log.debug("zWholeZSetItem(...) => result -> {}", new Object[]{result});
        }
        return result;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeWithScores(String key, long start, long end) {
        Set entries = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            this.log.debug("zRangeWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        }
        return entries;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zWholeZSetEntry(String key) {
        Set entries = this.redisTemplate.opsForZSet().rangeWithScores((Object)key, 0L, -1L);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zWholeZSetEntry(...) => key -> {}", new Object[]{key});
            this.log.debug("zWholeZSetEntry(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        }
        return entries;
    }

    public Set<Object> zRangeByScore(String key, double minScore, double maxScore) {
        Set items = this.redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            this.log.debug("zRangeByScore(...) => items -> {}", new Object[]{items});
        }
        return items;
    }

    public Set<Object> zRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
        Set items = this.redisTemplate.opsForZSet().rangeByScore((Object)key, minScore, maxScore, offset, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
            this.log.debug("zRangeByScore(...) => items -> {}", new Object[]{items});
        }
        return items;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double minScore, double maxScore) {
        Set entries = this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            this.log.debug("zRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        }
        return entries;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double minScore, double maxScore, long offset, long count) {
        Set entries = this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore, offset, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
            this.log.debug("zRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        }
        return entries;
    }

    public Set<Object> zReverseRange(String key, long start, long end) {
        Set entries = this.redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zReverseRange(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            this.log.debug("zReverseRange(...) => entries -> {}", new Object[]{entries});
        }
        return entries;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zReverseRangeWithScores(String key, long start, long end) {
        Set entries = this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zReverseRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            this.log.debug("zReverseRangeWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        }
        return entries;
    }

    public Set<Object> zReverseRangeByScore(String key, double minScore, double maxScore) {
        Set items = this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zReverseRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            this.log.debug("zReverseRangeByScore(...) => items -> {}", new Object[]{items});
        }
        return items;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zReverseRangeByScoreWithScores(String key, double minScore, double maxScore) {
        Set entries = this.redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, minScore, maxScore);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zReverseRangeByScoreWithScores(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            this.log.debug("zReverseRangeByScoreWithScores(...) => entries -> {}", new Object[]{JSON.toJSONString((Object)entries)});
        }
        return entries;
    }

    public Set<Object> zReverseRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
        Set items = this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore, offset, count);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zReverseRangeByScore(...) => key -> {}, minScore -> {}, maxScore -> {}, offset -> {}, count -> {}", new Object[]{key, minScore, maxScore, offset, count});
            this.log.debug("items -> {}", new Object[]{items});
        }
        return items;
    }

    public long zCount(String key, double minScore, double maxScore) {
        Long count = this.redisTemplate.opsForZSet().count((Object)key, minScore, maxScore);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zCount(...) => key -> {}, minScore -> {}, maxScore -> {}", new Object[]{key, minScore, maxScore});
            this.log.debug("zCount(...) => count -> {}", new Object[]{count});
        }
        if (count == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return count;
    }

    public long zSize(String key) {
        Long size = this.redisTemplate.opsForZSet().size((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zSize(...) => key -> {}", new Object[]{key});
            this.log.debug("zSize(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zZCard(String key) {
        Long size = this.redisTemplate.opsForZSet().zCard((Object)key);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zZCard(...) => key -> {}", new Object[]{key});
            this.log.debug("zZCard(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public double zScore(String key, Object item) {
        Double score = this.redisTemplate.opsForZSet().score((Object)key, item);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zScore(...) => key -> {}, item -> {}", new Object[]{key, item});
            this.log.debug("zScore(...) => score -> {}", new Object[]{score});
        }
        if (score == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return score;
    }

    public long zUnionAndStore(String key, String otherKey, String storeKey) {
        Long size = this.redisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zUnionAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            this.log.debug("zUnionAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
        Long size = this.redisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zUnionAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            this.log.debug("zUnionAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zIntersectAndStore(String key, String otherKey, String storeKey) {
        Long size = this.redisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zIntersectAndStore(...) => key -> {}, otherKey -> {}, storeKey -> {}", new Object[]{key, otherKey, storeKey});
            this.log.debug("zIntersectAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public long zIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
        Long size = this.redisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
        if (this.log.isDebugEnabled()) {
            this.log.debug("zIntersectAndStore(...) => key -> {}, otherKeys -> {}, storeKey -> {}", new Object[]{key, otherKeys, storeKey});
            this.log.debug("zIntersectAndStore(...) => size -> {}", new Object[]{size});
        }
        if (size == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return size;
    }

    public boolean getLock(String key, String value) {
        return this.getLock(key, value, 3L, this.DEFAULT_TIMEOUT_UNIT);
    }

    public boolean getLockUntilTimeout(String key, String value, long retryTimeoutLimit) {
        return this.getLockUntilTimeout(key, value, 3L, this.DEFAULT_TIMEOUT_UNIT, retryTimeoutLimit);
    }

    public boolean getLockUntilTimeout(String key, String value, long timeout, TimeUnit unit, long retryTimeoutLimit) {
        long startTime;
        if (this.log.isDebugEnabled()) {
            this.log.debug("getLockUntilTimeout(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}, retryTimeoutLimit -> {}ms", new Object[]{key, value, timeout, unit, retryTimeoutLimit});
        }
        long now = startTime = Instant.now().toEpochMilli();
        do {
            try {
                boolean alreadyGotLock = this.getLock(key, value, timeout, unit, false);
                if (alreadyGotLock) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("getLockUntilTimeout(...) => consume time -> {}ms, result -> true", new Object[]{now - startTime});
                    }
                    return true;
                }
            }
            catch (Exception e) {
                this.log.warn("getLockUntilTimeout(...) => try to get lock failure! e.getMessage -> {}", new Object[]{e.getMessage()});
            }
        } while ((now = Instant.now().toEpochMilli()) < startTime + retryTimeoutLimit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("getLockUntilTimeout(...) => consume time -> {}ms, result -> false", new Object[]{now - startTime});
        }
        return false;
    }

    public boolean getLock(String key, String value, long timeout, TimeUnit unit) {
        return this.getLock(key, value, timeout, unit, true);
    }

    public boolean getLock(String key, String value, long timeout, TimeUnit unit, boolean recordLog) {
        if (recordLog) {
            this.log.debug("getLock(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}", new Object[]{key, value, timeout, unit});
        }
        Boolean result = (Boolean)this.redisTemplate.execute(connection -> connection.set(key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8), Expiration.seconds((long)unit.toSeconds(timeout)), RedisStringCommands.SetOption.SET_IF_ABSENT));
        if (recordLog) {
            this.log.debug("getLock(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public boolean releaseLock(String key, String value) {
        Boolean result = (Boolean)this.redisTemplate.execute(connection -> (Boolean)connection.eval(this.RELEASE_LOCK_LUA.getBytes(), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8)}));
        if (this.log.isDebugEnabled()) {
            this.log.debug("releaseLock(...) => key -> {}, lockValue -> {}", new Object[]{key, value});
            this.log.debug("releaseLock(...) => result -> {}", new Object[]{result});
        }
        if (result == null) {
            BaseErrorEnum.INVALID_REDIS_RESULT_ERROR.throwException();
        }
        return result;
    }

    public static class Helper {
        public static final String DEFAULT_SYMBOL = ":";

        public static String join(String ... args) {
            return Helper.joinBySymbol(DEFAULT_SYMBOL, args);
        }

        public static String joinBySymbol(String symbol, String ... args) {
            if (symbol == null || symbol.trim().length() == 0) {
                throw new RuntimeException(" symbol must not be empty!");
            }
            if (args == null || args.length == 0) {
                throw new RuntimeException(" args must not be empty!");
            }
            StringBuilder sb = new StringBuilder(16);
            for (String arg : args) {
                sb.append(arg).append(symbol);
            }
            sb.replace(sb.length() - symbol.length(), sb.length(), "");
            return sb.toString();
        }
    }
}

