/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.lock;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.enums.BaseErrorEnum;
import top.isopen.commons.springboot.lock.LockParameter;
import top.isopen.commons.springboot.lock.annotation.RedLock;

@Aspect
public class RedLockAspect {
    private static final Log log = LogFactory.getLog(RedLockAspect.class);
    private final RedissonClient redissonClient;

    public RedLockAspect(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Around(value="@within(redLock) || @annotation(redLock)")
    public Object process(ProceedingJoinPoint joinPoint, RedLock redLock) throws Throwable {
        LockParameter parameter = new LockParameter(redLock, (JoinPoint)joinPoint);
        boolean fair = parameter.isFair();
        String key = parameter.getKey();
        RLock lock = fair ? this.redissonClient.getFairLock(key) : this.redissonClient.getLock(key);
        boolean locked = lock.tryLock(parameter.getWaitTime(), parameter.getLeaseTime(), parameter.getTimeUnit());
        if (!locked) {
            log.info("try lock failed: {}", new Object[]{key});
            BaseErrorEnum.INVALID_RED_LOCK_TRY_ERROR.throwException();
        }
        log.info("try lock succeed: {}", new Object[]{key});
        return joinPoint.proceed();
    }
}

