/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.enums;

import top.isopen.commons.springboot.enums.BaseErrorEnum;

public enum OnlineStatusEnum {
    ONLINE("online", "\u4e0a\u67b6"),
    OFFLINE("offline", "\u4e0b\u67b6");

    private static final OnlineStatusEnum[] VALUES;
    private final String value;
    private final String description;

    private OnlineStatusEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static OnlineStatusEnum resolve(String value) {
        String valueLowerCase = value.toLowerCase();
        for (OnlineStatusEnum onlineStatusEnum : VALUES) {
            if (!onlineStatusEnum.value.equals(valueLowerCase)) continue;
            return onlineStatusEnum;
        }
        BaseErrorEnum.INVALID_ONLINE_TYPE_ERROR.throwException();
        return OFFLINE;
    }

    public static String resolve(OnlineStatusEnum status) {
        return status != null ? status.getValue() : null;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        VALUES = OnlineStatusEnum.values();
    }
}

