/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.exception;

import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.bean.Result;
import top.isopen.commons.springboot.exception.BaseException;

@RestControllerAdvice
public class BaseExceptionHandler {
    private final Log log = LogFactory.getLog(BaseExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public ResponseEntity<Result<Object>> handleBaseException(BaseException exception) {
        this.log.error("BaseException ! error: {}, {}, {}", new Object[]{exception.getMessage(), exception.getDescription(), exception.getStackTrace()});
        return new ResponseEntity(Result.error(exception.getCode(), exception.getMessage(), exception.getDescription()), (MultiValueMap)new HttpHeaders(), exception.getHttpStatus());
    }
}

