/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.types;

import top.isopen.commons.springboot.enums.OnlineStatusEnum;
import top.isopen.commons.springboot.model.BaseModel;
import top.isopen.commons.springboot.types.AbstractType;
import top.isopen.commons.springboot.types.BaseType;

public abstract class OnlineType<T extends BaseType, R extends BaseModel>
extends AbstractType<T, R> {
    private OnlineStatusEnum status;

    public boolean isOnline() {
        return this.status != null && this.status.equals((Object)OnlineStatusEnum.ONLINE);
    }

    public boolean isOffline() {
        return this.status != null && this.status.equals((Object)OnlineStatusEnum.OFFLINE);
    }

    @Override
    public void updateAll(T current) {
        this.setStatus(((OnlineType)current).getStatus());
    }

    @Override
    public void updatePart(T current) {
        if (((OnlineType)current).getStatus() != null) {
            this.setStatus(((OnlineType)current).getStatus());
        }
    }

    protected OnlineType(OnlineTypeBuilder<T, R, ?, ?> b) {
        super(b);
        this.status = ((OnlineTypeBuilder)b).status;
    }

    public OnlineStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(OnlineStatusEnum status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "OnlineType(status=" + (Object)((Object)this.getStatus()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnlineType)) {
            return false;
        }
        OnlineType other = (OnlineType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OnlineStatusEnum this$status = this.getStatus();
        OnlineStatusEnum other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OnlineType;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OnlineStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public static abstract class OnlineTypeBuilder<T extends BaseType, R extends BaseModel, C extends OnlineType<T, R>, B extends OnlineTypeBuilder<T, R, C, B>>
    extends AbstractType.AbstractTypeBuilder<T, R, C, B> {
        private OnlineStatusEnum status;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OnlineTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static <T extends BaseType, R extends BaseModel> void $fillValuesFromInstanceIntoBuilder(OnlineType<T, R> instance, OnlineTypeBuilder<T, R, ?, ?> b) {
            b.status(((OnlineType)instance).status);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B status(OnlineStatusEnum status) {
            this.status = status;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "OnlineType.OnlineTypeBuilder(super=" + super.toString() + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

