/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.lock;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import top.isopen.commons.springboot.enums.BaseErrorEnum;
import top.isopen.commons.springboot.lock.annotation.RedLock;
import top.isopen.commons.springboot.lock.annotation.RedLocks;

public final class LockParameter {
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private static final String KEY_SEPARATOR = ":";
    private static final char SP_EL_PREFIX = '#';
    private final String key;
    private final String[] keys;
    private final String[] parameters;
    private final Object[] args;
    private final boolean fair;
    private final long leaseTime;
    private final TimeUnit timeUnit;
    private final long waitTime;

    LockParameter(RedLock redLock, JoinPoint joinPoint) {
        this.keys = null;
        this.parameters = parameterNameDiscoverer.getParameterNames(((MethodSignature)joinPoint.getSignature()).getMethod());
        this.args = joinPoint.getArgs();
        if (this.parameters != null && this.parameters.length != this.args.length) {
            BaseErrorEnum.INVALID_RED_LOCK_ASPECT_PARAMETER_ERROR.throwException();
        }
        this.fair = redLock.isFair();
        this.leaseTime = redLock.leaseTime();
        this.timeUnit = redLock.timeUnit();
        this.waitTime = redLock.waitTime();
        this.key = LockParameter.resolveKey(redLock.key(), this.parameters, this.args);
    }

    LockParameter(RedLocks redLocks, JoinPoint joinPoint) {
        this.key = null;
        this.parameters = parameterNameDiscoverer.getParameterNames(((MethodSignature)joinPoint.getSignature()).getMethod());
        this.args = joinPoint.getArgs();
        if (this.parameters != null && this.parameters.length != this.args.length) {
            BaseErrorEnum.INVALID_RED_LOCK_ASPECT_PARAMETER_ERROR.throwException();
        }
        this.fair = redLocks.isFair();
        this.leaseTime = redLocks.leaseTime();
        this.timeUnit = redLocks.timeUnit();
        this.waitTime = redLocks.waitTime();
        this.keys = LockParameter.resolveKey(redLocks.keys(), this.parameters, this.args);
    }

    private static String resolveKey(String key, String[] parameters, Object[] args) {
        StandardEvaluationContext context = LockParameter.getElContext(parameters, args);
        return LockParameter.resolveKey(key, context);
    }

    private static String[] resolveKey(String[] keys, String[] parameters, Object[] args) {
        String[] values = new String[keys.length];
        StandardEvaluationContext context = LockParameter.getElContext(parameters, args);
        for (int i = 0; i < keys.length; ++i) {
            values[i] = LockParameter.resolveKey(keys[i], context);
        }
        return values;
    }

    private static String resolveKey(String key, StandardEvaluationContext context) {
        String[] comb = LockParameter.resolveEl(key);
        assert (comb != null);
        assert (comb.length == 3);
        String spEl = comb[1];
        String value = (String)spelExpressionParser.parseRaw(spEl).getValue((EvaluationContext)context, String.class);
        return (comb[0].length() != 0 ? comb[0] + KEY_SEPARATOR : "") + value + (comb[2].length() != 0 ? KEY_SEPARATOR + comb[2] : "");
    }

    private static String[] resolveEl(String el) {
        String[] splits = el.split(KEY_SEPARATOR);
        int n = splits.length;
        for (int i = 0; i < n; ++i) {
            String target = splits[i];
            if (target.charAt(0) != '#') continue;
            return new String[]{i == 0 ? "" : String.join((CharSequence)"", Arrays.copyOfRange(splits, 0, i)), target, i == n - 1 ? "" : String.join((CharSequence)"", Arrays.copyOfRange(splits, i + 1, n))};
        }
        BaseErrorEnum.INVALID_SP_EL_ERROR.throwException();
        return null;
    }

    private static StandardEvaluationContext getElContext(String[] parameters, Object[] args) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < args.length; ++i) {
            context.setVariable(parameters[i], args[i]);
        }
        return context;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean isFair() {
        return this.fair;
    }

    public long getLeaseTime() {
        return this.leaseTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LockParameter)) {
            return false;
        }
        LockParameter other = (LockParameter)o;
        if (this.isFair() != other.isFair()) {
            return false;
        }
        if (this.getLeaseTime() != other.getLeaseTime()) {
            return false;
        }
        if (this.getWaitTime() != other.getWaitTime()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getKeys(), other.getKeys())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getParameters(), other.getParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFair() ? 79 : 97);
        long $leaseTime = this.getLeaseTime();
        result = result * 59 + (int)($leaseTime >>> 32 ^ $leaseTime);
        long $waitTime = this.getWaitTime();
        result = result * 59 + (int)($waitTime >>> 32 ^ $waitTime);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getKeys());
        result = result * 59 + Arrays.deepHashCode(this.getParameters());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        return result;
    }

    public String toString() {
        return "LockParameter(key=" + this.getKey() + ", keys=" + Arrays.deepToString(this.getKeys()) + ", parameters=" + Arrays.deepToString(this.getParameters()) + ", args=" + Arrays.deepToString(this.getArgs()) + ", fair=" + this.isFair() + ", leaseTime=" + this.getLeaseTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", waitTime=" + this.getWaitTime() + ")";
    }
}

