/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.lock;

import io.reactivex.rxjava3.functions.BiFunction;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import top.isopen.commons.logging.Log;
import top.isopen.commons.logging.LogFactory;
import top.isopen.commons.springboot.enums.BaseErrorEnum;
import top.isopen.commons.springboot.lock.LockParameter;
import top.isopen.commons.springboot.lock.annotation.RedLock;
import top.isopen.commons.springboot.lock.annotation.RedLocks;

public abstract class AbstractRedLockAspect {
    private static final Log log = LogFactory.getLog(AbstractRedLockAspect.class);
    private final RedissonClient redissonClient;

    protected AbstractRedLockAspect(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    protected void lockOn(ProceedingJoinPoint joinPoint, RedLocks redLocks) throws Throwable {
        LockParameter parameter = new LockParameter(redLocks, (JoinPoint)joinPoint);
        String[] keys = parameter.getKeys();
        RLock multiLock = this.getLock(keys, parameter.isFair());
        this.lockOn(multiLock, parameter);
    }

    protected void lockOn(ProceedingJoinPoint joinPoint, RedLock redLock) throws Throwable {
        LockParameter parameter = new LockParameter(redLock, (JoinPoint)joinPoint);
        RLock lock = this.getLock(parameter.getKey(), parameter.isFair());
        this.lockOn(lock, parameter);
    }

    private RLock getLock(String key, boolean isFair) {
        return isFair ? this.redissonClient.getFairLock(key) : this.redissonClient.getLock(key);
    }

    private RLock getLock(String[] keys, boolean isFair) throws Throwable {
        BiFunction doGetLock = isFair ? RedissonClient::getFairLock : RedissonClient::getLock;
        RLock[] locks = new RLock[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            locks[i] = (RLock)doGetLock.apply((Object)this.redissonClient, (Object)keys[i]);
        }
        return this.redissonClient.getMultiLock(locks);
    }

    private void lockOn(RLock lock, LockParameter parameter) throws InterruptedException {
        long waitTime = parameter.getWaitTime();
        long leaseTime = parameter.getLeaseTime();
        TimeUnit timeUnit = parameter.getTimeUnit();
        if (waitTime == -1L) {
            lock.lock(leaseTime, timeUnit);
        } else {
            boolean locked = lock.tryLock(waitTime, leaseTime, timeUnit);
            if (!locked) {
                log.info("try lock failed");
                BaseErrorEnum.INVALID_RED_LOCK_TRY_ERROR.throwException();
            }
        }
        log.info("try lock succeed");
    }
}

