/*
 * Decompiled with CFR 0.152.
 */
package top.isopen.commons.springboot.repository.enums;

import top.isopen.commons.springboot.enums.BaseErrorEnum;

public enum QueryTypeEnum {
    EQ("eq", "\u7b49\u4e8e"),
    LIKE("like", "\u50cf"),
    OR("or", "\u6216\u8005"),
    AND("and", "\u5e76\u4e14"),
    NE("ne", "\u4e0d\u7b49\u4e8e"),
    LE("le", "\u5c0f\u4e8e\u7b49\u4e8e"),
    GE("ge", "\u5927\u4e8e\u7b49\u4e8e"),
    LT("lt", "\u5c0f\u4e8e"),
    GT("gt", "\u5927\u4e8e"),
    IN("in", "\u5907\u9009"),
    NOT_IN("notin", "\u6392\u9664");

    private static final QueryTypeEnum[] VALUES;
    private final String value;
    private final String description;

    private QueryTypeEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static QueryTypeEnum resolve(String value) {
        String valueLowerCase = value.toLowerCase();
        for (QueryTypeEnum queryTypeEnum : VALUES) {
            if (!queryTypeEnum.value.equals(valueLowerCase)) continue;
            return queryTypeEnum;
        }
        BaseErrorEnum.INVALID_QUERY_TYPE_ERROR.throwException();
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        VALUES = QueryTypeEnum.values();
    }
}

