/*
 * Decompiled with CFR 0.152.
 */
package top.iteratefast.codetool.project_generator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import top.iteratefast.codetool.project_generator.StringRender;

public class FileRender {
    static final Pattern FILE_LIST_PATTERN = Pattern.compile("^(#\\[(.+)\\]\\[(.+)\\]).*");

    public static void render(Map<String, Object> data, File sourceFile, File targetDir) throws IOException {
        String fileName = sourceFile.getName();
        String tpl = Files.toString((File)sourceFile, (Charset)Charsets.UTF_8);
        if (fileName.startsWith("#[")) {
            FileRender.renderFileList(fileName, tpl, data, targetDir);
        } else {
            System.out.println("    Render File : " + targetDir.toPath().toString());
            Files.write((CharSequence)StringRender.render(tpl, data), (File)new File(targetDir, fileName), (Charset)Charsets.UTF_8);
        }
    }

    public static void renderFileList(String srcFileName, String srcContent, Map<String, Object> data, File targetDir) {
        Matcher fileListMatcher = FILE_LIST_PATTERN.matcher(srcFileName);
        if (fileListMatcher.matches()) {
            String nameVarPlaceHolder = fileListMatcher.group(1);
            String fileListVar = fileListMatcher.group(2);
            String fileNameVar = fileListMatcher.group(3);
            System.out.println(String.format("    Render File list : fileListVar : %s , fileNameVar : %s", fileListVar, fileNameVar));
            Object fileListData = data.get(fileListVar);
            if (fileListData != null || fileListData instanceof Collection) {
                Collection listData = (Collection)fileListData;
                for (Object listItemData : listData) {
                    data.put("_fileContext", listItemData);
                    try {
                        String fileNamePlaceHolderValue = String.valueOf(BeanUtils.getProperty(listItemData, (String)fileNameVar));
                        String fileName = srcFileName.replace(nameVarPlaceHolder, fileNamePlaceHolderValue);
                        if (fileName.endsWith(".java")) {
                            data.put("_className", fileName.substring(0, fileName.length() - 5));
                        }
                        File outputFile = new File(targetDir, fileName);
                        System.out.println("    Render file : " + outputFile.toPath().toString());
                        StringRender.render(srcContent, data, outputFile);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("\u5728\u6e32\u67d3\u6587\u4ef6\u5217\u8868\u65f6\uff0c\u671f\u671b\u5f97\u6587\u4ef6\u540d\u53d8\u91cf(\u8bf7\u68c0\u67e5\u6570\u636e\u7c7b\u662f\u4e0d\u662fpublic\u5e76\u4e14\u63d0\u4f9b\u4e86getter):" + fileNameVar, e);
                    }
                }
            } else {
                throw new IllegalArgumentException("\u5728\u6e32\u67d3\u6587\u4ef6\u5217\u8868\u65f6\uff0c\u671f\u671b\u5f97\u5230\u4e00\u4e2a\u96c6\u5408:" + fileListVar);
            }
        }
    }
}

