/*
 * Decompiled with CFR 0.152.
 */
package top.iteratefast.codetool.project_generator;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class PathUtils {
    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    public static File initTmpDir() {
        File targetDir = PathUtils.getUserHomeDir();
        File tmpDir = new File(targetDir, ".iteratorfast/tmp/" + UUID.randomUUID().toString());
        tmpDir.mkdirs();
        return tmpDir;
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (dir.isDirectory()) {
            String[] childrens;
            for (String child : childrens = dir.list()) {
                boolean success = PathUtils.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static Set<String> getRelativePaths(File file) {
        return PathUtils.getRelativePaths(file.toPath().toString().length(), file);
    }

    private static Set<String> getRelativePaths(int fromIdx, File file) {
        TreeSet<String> allFiles = new TreeSet<String>();
        String fullPath = file.toPath().toString();
        if (fullPath.length() > fromIdx) {
            String path = fullPath.substring(fromIdx + 1).replaceAll("\\\\", "/");
            allFiles.add(path);
        }
        if (file.isDirectory()) {
            String[] list;
            for (String subFileName : list = file.list()) {
                allFiles.addAll(PathUtils.getRelativePaths(fromIdx, new File(file, subFileName)));
            }
        }
        return allFiles;
    }

    public static File getProjectDir(Class classInProject) {
        File classPath = new File(classInProject.getClassLoader().getResource("").getPath());
        String pkg = classInProject.getPackage().getName().replaceAll("\\.", "/");
        String javaFile = "src/main/java/" + pkg + File.separator + classInProject.getSimpleName() + ".java";
        for (File dir = classPath.getParentFile(); dir != null && dir.isDirectory(); dir = dir.getParentFile()) {
            if (!new File(dir, javaFile).exists()) continue;
            return dir;
        }
        return null;
    }
}

