/*
 * Decompiled with CFR 0.152.
 */
package top.iteratefast.codetool.project_generator;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import top.iteratefast.codetool.project_generator.FileRender;
import top.iteratefast.codetool.project_generator.PathUtils;
import top.iteratefast.codetool.project_generator.StringRender;

public class ProjectRender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(Map<String, Object> data, File templateFolder, File outPutFolder, boolean overwrite) throws IOException {
        File tmpDir = PathUtils.initTmpDir();
        try {
            Map<String, String> pathMapping = ProjectRender.getPathMapping(templateFolder, data);
            for (Map.Entry<String, String> entry : pathMapping.entrySet()) {
                System.out.println("Generate : " + entry.getKey() + "   >   " + entry.getValue());
                File src = new File(templateFolder, entry.getKey());
                File target = new File(tmpDir, entry.getValue());
                if (src.isDirectory()) {
                    System.out.println("    mkdir : " + target.toPath().toString());
                    target.mkdirs();
                    continue;
                }
                if (!src.isFile()) continue;
                FileRender.render(data, src, target.getParentFile());
            }
            ProjectRender.copy(tmpDir, outPutFolder, overwrite);
        }
        finally {
            PathUtils.deleteDir(tmpDir);
        }
    }

    private static void copy(File tmpDir, File outPutFolder, boolean overwrite) {
        Set<String> sourceFiles = PathUtils.getRelativePaths(tmpDir);
        if (!outPutFolder.exists()) {
            outPutFolder.mkdirs();
        } else if (!overwrite) {
            Set<String> targetFiles = PathUtils.getRelativePaths(outPutFolder);
            for (String sourceFile : sourceFiles) {
                if (!targetFiles.contains(sourceFile) || !new File(sourceFile).isFile()) continue;
                System.err.println("[Error] Generate code field !!! target file exist : " + sourceFile);
                return;
            }
        }
        for (String sourceFile : sourceFiles) {
            try {
                File src = new File(tmpDir, sourceFile);
                File target = new File(outPutFolder, sourceFile);
                if (src.isDirectory()) {
                    System.out.println("mkdir : " + target.getPath());
                    target.mkdirs();
                    continue;
                }
                System.out.println("copy form " + src.getPath() + " to " + target.getPath());
                Files.copy((File)src, (File)target);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static Map<String, String> getPathMapping(File templateFolder, Map<String, Object> data) {
        Set<String> allFiles = PathUtils.getRelativePaths(templateFolder);
        TreeMap<String, String> pathMapping = new TreeMap<String, String>();
        for (String path : allFiles) {
            pathMapping.put(path, StringRender.render(path, data));
        }
        return pathMapping;
    }
}

