/*
 * Decompiled with CFR 0.152.
 */
package top.iteratefast.codetool.project_generator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.StringTemplateResourceLoader;

public class StringRender {
    static final GroupTemplate TPL_FACTORY = StringRender.initGroupTeplete();

    public static String render(String source, Map<String, Object> data) {
        Template tpl = TPL_FACTORY.getTemplate(source);
        tpl.binding(data);
        return tpl.render();
    }

    public static void render(String source, Map<String, Object> data, File outputFile) throws IOException {
        String result = StringRender.render(source, data);
        Files.write((CharSequence)result, (File)outputFile, (Charset)Charsets.UTF_8);
    }

    static GroupTemplate initGroupTeplete() {
        StringTemplateResourceLoader resourceLoader = new StringTemplateResourceLoader();
        try {
            Configuration cfg = Configuration.defaultConfiguration();
            cfg.setPlaceholderStart("#{");
            cfg.setPlaceholderEnd("}");
            return new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

