/*
 * Decompiled with CFR 0.152.
 */
package top.iteratefast.bootstarter.restful.vo;

import java.io.Serializable;
import top.iteratefast.bootstarter.restful.error.BizError;
import top.iteratefast.bootstarter.restful.error.SysErrors;

public class Resp<T>
implements Serializable {
    private static final long serialVersionUID = 678807724492040902L;
    boolean success = true;
    T result;
    String errorCode;
    String errorDescription;
    String errorMsg;

    public static <T> Resp<T> success(T result) {
        Resp<T> resp = new Resp<T>();
        resp.success = true;
        resp.result = result;
        return resp;
    }

    public static Resp<String> success() {
        return Resp.success("OK");
    }

    public static Resp error(Exception e) {
        BizError bizError = SysErrors.SYS_ERR_INTERNAL;
        if (e instanceof BizError) {
            bizError = (BizError)e;
        }
        return Resp.error(String.valueOf(bizError.getCode()), bizError.getDescription(), bizError.getMessage());
    }

    public static Resp error(String errorCode, String errorDescription, String errorMsg) {
        Resp resp = new Resp();
        resp.success = false;
        resp.errorCode = errorCode;
        resp.errorDescription = errorDescription;
        resp.errorMsg = errorMsg;
        return resp;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Resp setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Resp setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Resp setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public T getResult() {
        return this.result;
    }

    public Resp setResult(T result) {
        this.result = result;
        return this;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public Resp setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }
}

