/*
 * Decompiled with CFR 0.152.
 */
package top.iteratefast.bootstarter.restful.validator.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;
import top.iteratefast.bootstarter.restful.error.BizError;
import top.iteratefast.bootstarter.restful.error.SysErrors;
import top.iteratefast.bootstarter.restful.utils.JsonUtils;
import top.iteratefast.bootstarter.restful.vo.Resp;

@ControllerAdvice
public class ControllerAdviceExceptionHandler {
    @ExceptionHandler(value={BizError.class})
    @ResponseBody
    Resp<Object> handleException(BizError error) {
        return Resp.error(error);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    Resp<Object> handleException(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        List list = bindingResult.getAllErrors();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        for (ObjectError objectError : list) {
            errorMsgList.add(objectError.getDefaultMessage());
        }
        return Resp.error(SysErrors.SYS_ERR_VALIDATION_ERROR.withDescription(JsonUtils.toJson(errorMsgList)));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    Resp<Object> handleException(ConstraintViolationException error) {
        Resp resp = Resp.error((Exception)error);
        ArrayList<String> errorMsgList = new ArrayList<String>();
        Set set = error.getConstraintViolations();
        for (ConstraintViolation constraintViolation : set) {
            errorMsgList.add(constraintViolation.getMessage());
        }
        resp.setErrorDescription(JsonUtils.toJson(errorMsgList));
        return resp;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseBody
    Resp<Object> handleException(NoHandlerFoundException error) {
        return Resp.error(SysErrors.SYS_ERR_API_NOT_FUND.withDescription(JsonUtils.toJson(error.getMessage())));
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    Resp<Object> handleException(Exception error) {
        return Resp.error(SysErrors.SYS_ERR_INTERNAL.withDescription(JsonUtils.toJson(error.getMessage())));
    }
}

