/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import top.jfunc.common.fastexcel.Alignment;
import top.jfunc.common.fastexcel.Border;
import top.jfunc.common.fastexcel.Fill;
import top.jfunc.common.fastexcel.Font;
import top.jfunc.common.fastexcel.Range;

public class StyleSetter {
    private final Range range;
    private String valueFormatting;
    private String fillColor;
    private String alternateShadingFillColor;
    private boolean bold;
    private boolean italic;
    private String fontColor;
    private String horizontalAlignment;
    private String verticalAlignment;
    private boolean wrapText;
    private String borderStyle;
    private String borderColor;

    StyleSetter(Range range) {
        this.range = range;
    }

    public StyleSetter format(String numberingFormat) {
        this.valueFormatting = numberingFormat;
        return this;
    }

    public StyleSetter fillColor(String rgb) {
        this.fillColor = rgb;
        return this;
    }

    public StyleSetter shadeAlternateRows(String rgb) {
        this.alternateShadingFillColor = rgb;
        return this;
    }

    public StyleSetter fontColor(String rgb) {
        this.fontColor = rgb;
        return this;
    }

    public StyleSetter bold() {
        this.bold = true;
        return this;
    }

    public StyleSetter italic() {
        this.italic = true;
        return this;
    }

    public StyleSetter horizontalAlignment(String alignment) {
        this.horizontalAlignment = alignment;
        return this;
    }

    public StyleSetter verticalAlignment(String alignment) {
        this.verticalAlignment = alignment;
        return this;
    }

    public StyleSetter wrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    public StyleSetter borderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
        return this;
    }

    public StyleSetter borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public StyleSetter merge() {
        this.range.merge();
        return this;
    }

    public void set() {
        Alignment alignment = this.horizontalAlignment != null || this.verticalAlignment != null || this.wrapText ? new Alignment(this.horizontalAlignment, this.verticalAlignment, this.wrapText) : null;
        Font font = this.bold || this.italic || this.fontColor != null ? Font.build(this.bold, this.italic, this.fontColor) : Font.DEFAULT;
        Fill fill = this.fillColor != null ? Fill.fromColor(this.fillColor) : Fill.NONE;
        Border border = this.borderStyle != null || this.borderColor != null ? Border.fromStyleAndColor(this.borderStyle, this.borderColor) : Border.NONE;
        Set<Integer> currentStyles = this.range.getStyles();
        Map<Integer, Integer> newStyles = currentStyles.stream().collect(Collectors.toMap(Function.identity(), s -> this.range.getWorksheet().getWorkbook().mergeAndCacheStyle((int)s, this.valueFormatting, font, fill, border, alignment)));
        this.range.applyStyle(newStyles);
        if (this.alternateShadingFillColor != null) {
            this.range.shadeAlternateRows(Fill.fromColor(this.alternateShadingFillColor, false));
        }
    }
}

