/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import top.jfunc.common.fastexcel.Alignment;
import top.jfunc.common.fastexcel.Border;
import top.jfunc.common.fastexcel.CachedString;
import top.jfunc.common.fastexcel.Fill;
import top.jfunc.common.fastexcel.Font;
import top.jfunc.common.fastexcel.StringCache;
import top.jfunc.common.fastexcel.StyleCache;
import top.jfunc.common.fastexcel.ThrowingConsumer;
import top.jfunc.common.fastexcel.Worksheet;
import top.jfunc.common.fastexcel.Writer;

public class Workbook {
    private final String applicationName;
    private final String applicationVersion;
    private final List<Worksheet> worksheets = new ArrayList<Worksheet>();
    private final StringCache stringCache = new StringCache();
    private final StyleCache styleCache = new StyleCache();
    private final ZipOutputStream os;
    private final Writer w;

    public Workbook(OutputStream os, String applicationName, String applicationVersion) {
        this.os = new ZipOutputStream(os, Charset.forName("UTF-8"));
        this.w = new Writer(this.os);
        this.applicationName = Objects.requireNonNull(applicationName);
        if (applicationVersion != null && !applicationVersion.matches("\\d{1,2}\\.\\d{1,4}")) {
            throw new IllegalArgumentException("Application version must be of the form XX.YYYY");
        }
        this.applicationVersion = applicationVersion;
    }

    public void finish() throws IOException {
        if (this.worksheets.isEmpty()) {
            throw new IllegalArgumentException("A workbook must contain at least one worksheet.");
        }
        for (Worksheet ws : this.worksheets) {
            ws.finish();
        }
        this.writeFile("[Content_Types].xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\"><Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/><Default Extension=\"xml\" ContentType=\"application/xml\"/><Override PartName=\"/xl/sharedStrings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\"/><Override PartName=\"/xl/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\"/><Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\"/>");
            for (Worksheet ws : this.worksheets) {
                w.append("<Override PartName=\"/xl/worksheets/sheet").append(this.getIndex(ws)).append(".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>");
            }
            w.append("<Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/><Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/></Types>");
        });
        this.writeFile("docProps/app.xml", w -> w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\"><Application>").appendEscaped(this.applicationName).append("</Application>").append(this.applicationVersion == null ? "" : "<AppVersion>" + this.applicationVersion + "</AppVersion>").append("</Properties>"));
        this.writeFile("docProps/core.xml", w -> w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><dcterms:created xsi:type=\"dcterms:W3CDTF\">").append(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("Z</dcterms:created><dc:creator>").appendEscaped(this.applicationName).append("</dc:creator></cp:coreProperties>"));
        this.writeFile("_rels/.rels", w -> w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId3\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties\" Target=\"docProps/app.xml\"/><Relationship Id=\"rId2\" Type=\"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties\" Target=\"docProps/core.xml\"/><Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\" Target=\"xl/workbook.xml\"/></Relationships>"));
        this.writeFile("xl/workbook.xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"><workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"0\"/></bookViews><sheets>");
            for (Worksheet ws : this.worksheets) {
                w.append("<sheet name=\"").appendEscaped(ws.getName()).append("\" r:id=\"rId").append(this.getIndex(ws) + 2).append("\" sheetId=\"").append(this.getIndex(ws)).append("\"/>");
            }
            w.append("</sheets></workbook>");
        });
        this.writeFile("xl/_rels/workbook.xml.rels", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/><Relationship Id=\"rId2\" Target=\"styles.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\"/>");
            for (Worksheet ws : this.worksheets) {
                w.append("<Relationship Id=\"rId").append(this.getIndex(ws) + 2).append("\" Target=\"worksheets/sheet").append(this.getIndex(ws)).append(".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\"/>");
            }
            w.append("</Relationships>");
        });
        this.writeFile("xl/sharedStrings.xml", this.stringCache::write);
        this.writeFile("xl/styles.xml", this.styleCache::write);
        this.os.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(String name, ThrowingConsumer<Writer> consumer) throws IOException {
        ZipOutputStream zipOutputStream = this.os;
        synchronized (zipOutputStream) {
            this.os.putNextEntry(new ZipEntry(name));
            consumer.accept(this.w);
            this.w.flush();
            this.os.closeEntry();
        }
    }

    CachedString cacheString(String s) {
        return this.stringCache.cacheString(s);
    }

    int mergeAndCacheStyle(int currentStyle, String numberingFormat, Font font, Fill fill, Border border, Alignment alignment) {
        return this.styleCache.mergeAndCacheStyle(currentStyle, numberingFormat, font, fill, border, alignment);
    }

    int cacheAlternateShadingFillColor(Fill fill) {
        return this.styleCache.cacheDxf(fill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex(Worksheet ws) {
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            return this.worksheets.indexOf(ws) + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worksheet newWorksheet(String name) {
        String sheetName = name.replaceAll("[/\\\\\\?\\*\\]\\[\\:]", "-");
        Worksheet worksheet = new Worksheet(this, sheetName);
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            this.worksheets.add(worksheet);
        }
        return worksheet;
    }
}

