/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import top.jfunc.common.fastexcel.AlternateShading;
import top.jfunc.common.fastexcel.CachedString;
import top.jfunc.common.fastexcel.Cell;
import top.jfunc.common.fastexcel.Fill;
import top.jfunc.common.fastexcel.Formula;
import top.jfunc.common.fastexcel.Range;
import top.jfunc.common.fastexcel.StyleSetter;
import top.jfunc.common.fastexcel.TimestampUtil;
import top.jfunc.common.fastexcel.Workbook;
import top.jfunc.common.fastexcel.Writer;

public class Worksheet {
    private final Workbook workbook;
    private final String name;
    private final List<Cell[]> rows = new ArrayList<Cell[]>();
    private final Set<Range> mergedRanges = new HashSet<Range>();
    private final List<AlternateShading> alternateShadingRanges = new ArrayList<AlternateShading>();
    private boolean finished = false;

    Worksheet(Workbook workbook, String name) {
        this.workbook = Objects.requireNonNull(workbook);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    Cell cell(int r, int c) {
        while (r >= this.rows.size()) {
            this.rows.add(null);
        }
        Cell[] row = this.rows.get(r);
        if (row == null) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            row = new Cell[columns];
            this.rows.set(r, row);
        } else if (c >= row.length) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            Cell[] tmp = new Cell[columns];
            System.arraycopy(row, 0, tmp, 0, row.length);
            row = tmp;
            this.rows.set(r, row);
        }
        if (row[c] == null) {
            row[c] = new Cell();
        }
        return row[c];
    }

    void merge(Range range) {
        this.mergedRanges.add(range);
    }

    void shadeAlternateRows(Range range, Fill fill) {
        this.alternateShadingRanges.add(new AlternateShading(range, this.getWorkbook().cacheAlternateShadingFillColor(fill)));
    }

    public void value(int r, int c, Object value) {
        if (value instanceof String) {
            this.cell((int)r, (int)c).value = this.workbook.cacheString((String)value);
        } else if (value == null || value instanceof Number) {
            this.cell((int)r, (int)c).value = value;
        } else if (value instanceof Date) {
            this.cell((int)r, (int)c).value = TimestampUtil.convertDate((Date)value);
        } else if (value instanceof LocalDateTime) {
            this.cell((int)r, (int)c).value = TimestampUtil.convertDate(Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant()));
        } else if (value instanceof LocalDate) {
            this.cell((int)r, (int)c).value = TimestampUtil.convertDate((LocalDate)value);
        } else if (value instanceof ZonedDateTime) {
            this.cell((int)r, (int)c).value = TimestampUtil.convertZonedDateTime((ZonedDateTime)value);
        } else {
            throw new IllegalArgumentException("No supported cell type for " + value.getClass().toString());
        }
    }

    public Object value(int r, int c) {
        Object o;
        Cell[] row = r < this.rows.size() ? this.rows.get(r) : null;
        Cell cell = row == null || c >= row.length ? null : row[c];
        Object object = o = cell == null ? null : cell.value;
        if (o instanceof CachedString) {
            o = ((CachedString)o).getString();
        }
        return o;
    }

    public void formula(int r, int c, String expression) {
        this.cell((int)r, (int)c).value = new Formula(expression);
    }

    public StyleSetter style(int r, int c) {
        return new Range(this, r, c, r, c).style();
    }

    public Range range(int top, int left, int bottom, int right) {
        return new Range(this, top, left, bottom, right);
    }

    private void writeCols(Writer w, int nbCols) throws IOException {
        w.append("<cols>");
        for (int c = 0; c < nbCols; ++c) {
            double maxWidth = 0.0;
            for (int r = 0; r < this.rows.size(); ++r) {
                Object o;
                boolean ignore = false;
                for (Range range : this.mergedRanges) {
                    if (!range.contains(r, c)) continue;
                    ignore = true;
                    break;
                }
                Object object = o = ignore ? null : this.value(r, c);
                if (o == null || o instanceof Formula) continue;
                int length = o.toString().length();
                maxWidth = Math.max(maxWidth, (double)((int)((double)(length * 7 + 10) / 7.0 * 256.0)) / 256.0);
            }
            if (!(maxWidth > 0.0)) continue;
            w.append("<col min=\"").append(c + 1).append("\" max=\"").append(c + 1).append("\" width=\"").append(Math.min(255.0, maxWidth)).append("\" customWidth=\"true\" bestFit=\"true\"/>");
        }
        w.append("</cols>");
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        int index = this.workbook.getIndex(this);
        this.workbook.writeFile("xl/worksheets/sheet" + Integer.toString(index) + ".xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"><dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"/></sheetViews><sheetFormatPr defaultRowHeight=\"15.0\"/>");
            int nbCols = this.rows.stream().filter(r -> r != null).map(r -> ((Cell[])r).length).reduce(0, Math::max);
            if (nbCols > 0) {
                this.writeCols((Writer)w, nbCols);
            }
            w.append("<sheetData>");
            for (int r2 = 0; r2 < this.rows.size(); ++r2) {
                Cell[] row = this.rows.get(r2);
                if (row == null) continue;
                Worksheet.writeRow(w, r2, row);
            }
            w.append("</sheetData>");
            if (!this.mergedRanges.isEmpty()) {
                w.append("<mergeCells>");
                for (Range r3 : this.mergedRanges) {
                    w.append("<mergeCell ref=\"").append(r3.toString()).append("\"/>");
                }
                w.append("</mergeCells>");
            }
            for (AlternateShading a : this.alternateShadingRanges) {
                a.write((Writer)w);
            }
            w.append("<pageMargins bottom=\"0.75\" footer=\"0.3\" header=\"0.3\" left=\"0.7\" right=\"0.7\" top=\"0.75\"/></worksheet>");
        });
        this.rows.clear();
        this.finished = true;
    }

    private static void writeRow(Writer w, int r, Cell ... row) throws IOException {
        w.append("<row r=\"").append(r + 1).append("\">");
        for (int c = 0; c < row.length; ++c) {
            if (row[c] == null) continue;
            row[c].write(w, r, c);
        }
        w.append("</row>");
    }
}

