/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.excel.ExcelCell;
import top.jfunc.common.excel.ExcelLog;
import top.jfunc.common.excel.ExcelLogs;
import top.jfunc.common.excel.ExcelSheet;
import top.jfunc.common.excel.FieldForSortting;
import top.jfunc.common.utils.StrUtil;

public class ExcelUtil {
    private static Logger LG = LoggerFactory.getLogger(ExcelUtil.class);
    private static Map<Class<?>, Integer[]> validateMap = new HashMap();

    private static String getCellTypeByInt(int cellType) {
        switch (cellType) {
            case 3: {
                return "Null type";
            }
            case 4: {
                return "Boolean type";
            }
            case 5: {
                return "Error type";
            }
            case 2: {
                return "Formula type";
            }
            case 0: {
                return "Numeric type";
            }
            case 1: {
                return "String type";
            }
        }
        return "Unknown type";
    }

    private static Object getCellValue(Cell cell) {
        if (cell == null || cell.getCellType() == 1 && StrUtil.isBlank((CharSequence)cell.getStringCellValue())) {
            return null;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 3: {
                return null;
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 5: {
                return cell.getErrorCellValue();
            }
            case 2: {
                return cell.getNumericCellValue();
            }
            case 0: {
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
        }
        return null;
    }

    public static <T> void exportExcel(String[] headers, Collection<T> dataset, OutputStream out) {
        ExcelUtil.exportExcel(headers, dataset, out, null);
    }

    public static <T> void exportExcel(String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        ExcelUtil.write2Sheet(sheet, headers, dataset, pattern);
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            LG.error(e.toString(), (Throwable)e);
        }
    }

    public static <T> void exportExcel(List<ExcelSheet<T>> sheets, OutputStream out) {
        ExcelUtil.exportExcel(sheets, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void exportExcel(List<ExcelSheet<T>> sheets, OutputStream out, String pattern) {
        if (CollectionUtils.isEmpty(sheets)) {
            return;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (ExcelSheet<T> sheet : sheets) {
            HSSFSheet hssfSheet = workbook.createSheet(sheet.getSheetName());
            ExcelUtil.write2Sheet(hssfSheet, sheet.getHeaders(), sheet.getDataset(), pattern);
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            LG.error(e.toString(), (Throwable)e);
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T> void write2Sheet(HSSFSheet sheet, String[] headers, Collection<T> dataset, String pattern) {
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            try {
                int cellNum;
                if (t instanceof Map) {
                    Map map = (Map)t;
                    cellNum = 0;
                    for (String k : headers) {
                        if (!map.containsKey(k)) {
                            LG.error("Map \u4e2d \u4e0d\u5b58\u5728 key [" + k + "]");
                            continue;
                        }
                        Object value = map.get(k);
                        HSSFCell cell = row.createCell(cellNum);
                        cell.setCellValue(String.valueOf(value));
                        ++cellNum;
                    }
                    continue;
                }
                List<FieldForSortting> fields = ExcelUtil.sortFieldByAnno(t.getClass());
                cellNum = 0;
                for (int i = 0; i < fields.size(); ++i) {
                    HSSFCell cell = row.createCell(cellNum);
                    Field field = fields.get(i).getField();
                    field.setAccessible(true);
                    Object value = field.get(t);
                    String textValue = null;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        cell.setCellValue((double)fValue);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        cell.setCellValue(dValue);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Boolean) {
                        boolean bValue = (Boolean)value;
                        cell.setCellValue(bValue);
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                        textValue = sdf.format(date);
                    } else if (value instanceof String[]) {
                        String[] strArr = (String[])value;
                        for (int j = 0; j < strArr.length; ++j) {
                            String str = strArr[j];
                            cell.setCellValue(str);
                            if (j == strArr.length - 1) continue;
                            cell = row.createCell(++cellNum);
                        }
                    } else if (value instanceof Double[]) {
                        Double[] douArr = (Double[])value;
                        for (int j = 0; j < douArr.length; ++j) {
                            Double val = douArr[j];
                            if (val != null) {
                                cell.setCellValue(val.doubleValue());
                            }
                            if (j == douArr.length - 1) continue;
                            cell = row.createCell(++cellNum);
                        }
                    } else {
                        String empty = "";
                        ExcelCell anno = field.getAnnotation(ExcelCell.class);
                        if (anno != null) {
                            empty = anno.defaultValue();
                        }
                        String string = textValue = value == null ? empty : value.toString();
                    }
                    if (textValue != null) {
                        HSSFRichTextString richString = new HSSFRichTextString(textValue);
                        cell.setCellValue((RichTextString)richString);
                    }
                    ++cellNum;
                }
            }
            catch (Exception e) {
                LG.error(e.toString(), (Throwable)e);
            }
        }
        for (int i = 0; i < headers.length; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    public static <T> Collection<T> importExcel(Class<T> clazz, InputStream inputStream, String pattern, ExcelLogs logs, Integer ... arrayCount) throws EncryptedDocumentException, InvalidFormatException {
        Workbook workBook = null;
        try {
            workBook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (IOException e) {
            LG.error(e.toString(), (Throwable)e);
        }
        ArrayList list = new ArrayList();
        Sheet sheet = workBook.getSheetAt(0);
        Iterator rowIterator = sheet.rowIterator();
        try {
            ArrayList<ExcelLog> logList = new ArrayList<ExcelLog>();
            HashMap<String, Integer> titleMap = new HashMap<String, Integer>();
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                if (row.getRowNum() == 0) {
                    if (clazz != Map.class) continue;
                    Iterator cellIterator = row.cellIterator();
                    Integer index = 0;
                    while (cellIterator.hasNext()) {
                        String value = ((Cell)cellIterator.next()).getStringCellValue();
                        titleMap.put(value, index);
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                    }
                    continue;
                }
                boolean allRowIsNull = true;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Object cellValue = ExcelUtil.getCellValue((Cell)cellIterator.next());
                    if (cellValue == null) continue;
                    allRowIsNull = false;
                    break;
                }
                if (allRowIsNull) {
                    LG.warn("Excel row " + row.getRowNum() + " all row value is null!");
                    continue;
                }
                Object t = null;
                StringBuffer log = new StringBuffer();
                if (clazz == Map.class) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String k : titleMap.keySet()) {
                        Integer index = (Integer)titleMap.get(k);
                        Cell cell = row.getCell(index.intValue());
                        String value = null;
                        if (cell != null) {
                            int cellType = row.getCell(index.intValue()).getCellType();
                            if (cellType == 0) {
                                row.getCell(index.intValue()).setCellType(1);
                            }
                            value = row.getCell(index.intValue()).getStringCellValue();
                        }
                        map.put(k, value);
                    }
                    list.add(map);
                    continue;
                }
                t = clazz.newInstance();
                int arrayIndex = 0;
                int cellIndex = 0;
                List<FieldForSortting> fields = ExcelUtil.sortFieldByAnno(clazz);
                for (FieldForSortting ffs : fields) {
                    Field field = ffs.getField();
                    field.setAccessible(true);
                    if (field.getType().isArray()) {
                        Integer count = arrayCount[arrayIndex];
                        Object[] value = null;
                        value = field.getType().equals(String[].class) ? new String[count.intValue()] : new Double[count.intValue()];
                        for (int i = 0; i < count; ++i) {
                            Cell cell = row.getCell(cellIndex);
                            String errMsg = ExcelUtil.validateCell(cell, field, cellIndex);
                            if (StrUtil.isBlank((CharSequence)errMsg)) {
                                value[i] = ExcelUtil.getCellValue(cell);
                            } else {
                                log.append(errMsg);
                                log.append(";");
                                logs.setHasError(true);
                            }
                            ++cellIndex;
                        }
                        field.set(t, value);
                        ++arrayIndex;
                        continue;
                    }
                    Cell cell = row.getCell(cellIndex);
                    String errMsg = ExcelUtil.validateCell(cell, field, cellIndex);
                    if (StrUtil.isBlank((CharSequence)errMsg)) {
                        Object value = null;
                        if (field.getType().equals(Date.class) && cell.getCellType() == 1) {
                            Object strDate = ExcelUtil.getCellValue(cell);
                            try {
                                value = new SimpleDateFormat(pattern).parse(strDate.toString());
                            }
                            catch (ParseException e) {
                                errMsg = MessageFormat.format("the cell [{0}] can not be converted to a date ", CellReference.convertNumToColString((int)cell.getColumnIndex()));
                            }
                        } else {
                            value = ExcelUtil.getCellValue(cell);
                            ExcelCell annoCell = field.getAnnotation(ExcelCell.class);
                            if (value instanceof String && !field.getType().equals(String.class) && StrUtil.isNotBlank((CharSequence)annoCell.defaultValue())) {
                                value = annoCell.defaultValue();
                            }
                        }
                        field.set(t, value);
                    }
                    if (StrUtil.isNotBlank((CharSequence)errMsg)) {
                        log.append(errMsg);
                        log.append(";");
                        logs.setHasError(true);
                    }
                    ++cellIndex;
                }
                list.add(t);
                logList.add(new ExcelLog(t, log.toString(), row.getRowNum() + 1));
            }
            logs.setLogList(logList);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(MessageFormat.format("can not instance class:{0}", clazz.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(MessageFormat.format("can not instance class:{0}", clazz.getSimpleName()), e);
        }
        return list;
    }

    private static String validateCell(Cell cell, Field field, int cellNum) {
        String columnName = CellReference.convertNumToColString((int)cellNum);
        String result = null;
        Integer[] integers = validateMap.get(field.getType());
        if (integers == null) {
            result = MessageFormat.format("Unsupported type [{0}]", field.getType().getSimpleName());
            return result;
        }
        ExcelCell annoCell = field.getAnnotation(ExcelCell.class);
        if (cell == null || cell.getCellType() == 1 && StrUtil.isBlank((CharSequence)cell.getStringCellValue())) {
            if (annoCell != null && !annoCell.valid().allowNull()) {
                result = MessageFormat.format("the cell [{0}] can not null", columnName);
            }
        } else {
            if (cell.getCellType() == 3 && annoCell.valid().allowNull()) {
                return result;
            }
            List<Integer> cellTypes = Arrays.asList(integers);
            if (!cellTypes.contains(cell.getCellType()) || StrUtil.isNotBlank((CharSequence)annoCell.defaultValue()) && cell.getCellType() == 1) {
                StringBuffer strType = new StringBuffer();
                for (int i = 0; i < cellTypes.size(); ++i) {
                    Integer intType = cellTypes.get(i);
                    strType.append(ExcelUtil.getCellTypeByInt(intType));
                    if (i == cellTypes.size() - 1) continue;
                    strType.append(",");
                }
                result = MessageFormat.format("the cell [{0}] type must [{1}]", columnName, strType.toString());
            } else {
                if (annoCell.valid().in().length != 0 && cell.getCellType() == 1) {
                    String[] in = annoCell.valid().in();
                    String cellValue = cell.getStringCellValue();
                    boolean isIn = false;
                    for (String str : in) {
                        if (!str.equals(cellValue)) continue;
                        isIn = true;
                    }
                    if (!isIn) {
                        result = MessageFormat.format("the cell [{0}] value must in {1}", columnName, in);
                    }
                }
                if (cell.getCellType() == 0) {
                    double cellValue = cell.getNumericCellValue();
                    if (!Double.isNaN(annoCell.valid().lt()) && !(cellValue < annoCell.valid().lt())) {
                        result = MessageFormat.format("the cell [{0}] value must less than [{1}]", columnName, annoCell.valid().lt());
                    }
                    if (!Double.isNaN(annoCell.valid().gt()) && !(cellValue > annoCell.valid().gt())) {
                        result = MessageFormat.format("the cell [{0}] value must greater than [{1}]", columnName, annoCell.valid().gt());
                    }
                    if (!Double.isNaN(annoCell.valid().le()) && !(cellValue <= annoCell.valid().le())) {
                        result = MessageFormat.format("the cell [{0}] value must less than or equal [{1}]", columnName, annoCell.valid().le());
                    }
                    if (!Double.isNaN(annoCell.valid().ge()) && !(cellValue >= annoCell.valid().ge())) {
                        result = MessageFormat.format("the cell [{0}] value must greater than or equal [{1}]", columnName, annoCell.valid().ge());
                    }
                }
            }
        }
        return result;
    }

    private static List<FieldForSortting> sortFieldByAnno(Class<?> clazz) {
        Field[] fieldsArr = clazz.getDeclaredFields();
        ArrayList<FieldForSortting> fields = new ArrayList<FieldForSortting>();
        ArrayList annoNullFields = new ArrayList();
        for (Field field : fieldsArr) {
            ExcelCell ec = field.getAnnotation(ExcelCell.class);
            if (ec == null) continue;
            int id = ec.index();
            fields.add(new FieldForSortting(field, id));
        }
        fields.addAll(annoNullFields);
        ExcelUtil.sortByProperties(fields, true, false, "index");
        return fields;
    }

    private static void sortByProperties(List<? extends Object> list, boolean isNullHigh, boolean isReversed, String ... props) {
        if (CollectionUtils.isNotEmpty(list)) {
            Object typeComp = ComparableComparator.getInstance();
            typeComp = isNullHigh ? ComparatorUtils.nullHighComparator((Comparator)typeComp) : ComparatorUtils.nullLowComparator((Comparator)typeComp);
            if (isReversed) {
                typeComp = ComparatorUtils.reversedComparator((Comparator)typeComp);
            }
            ArrayList<BeanComparator> sortCols = new ArrayList<BeanComparator>();
            if (props != null) {
                for (String prop : props) {
                    sortCols.add(new BeanComparator(prop, (Comparator)typeComp));
                }
            }
            if (sortCols.size() > 0) {
                ComparatorChain sortChain = new ComparatorChain(sortCols);
                Collections.sort(list, sortChain);
            }
        }
    }

    public static String removeSpace(String src) {
        if (src == null) {
            return null;
        }
        if ("".equals(src)) {
            return "";
        }
        return src.replaceAll(" ", "");
    }

    static {
        validateMap.put(String[].class, new Integer[]{1});
        validateMap.put(Double[].class, new Integer[]{0});
        validateMap.put(String.class, new Integer[]{1});
        validateMap.put(Double.class, new Integer[]{0});
        validateMap.put(Date.class, new Integer[]{0, 1});
        validateMap.put(Integer.class, new Integer[]{0});
        validateMap.put(Float.class, new Integer[]{0});
        validateMap.put(Long.class, new Integer[]{0});
        validateMap.put(Boolean.class, new Integer[]{4});
    }
}

