/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.util.Objects;
import top.jfunc.common.fastexcel.Writer;

class Fill {
    static final Fill NONE = new Fill("none", null, true);
    static final Fill GRAY125 = new Fill("gray125", null, true);
    private final String patternType;
    private final String colorRgb;
    private final boolean fg;

    Fill(String patternType, String colorRgb, boolean fg) {
        this.patternType = patternType;
        this.colorRgb = colorRgb;
        this.fg = fg;
    }

    static Fill fromColor(String fgColorRgb) {
        return Fill.fromColor(fgColorRgb, true);
    }

    static Fill fromColor(String colorRgb, boolean fg) {
        return new Fill("solid", colorRgb, fg);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.patternType);
        hash = 83 * hash + Objects.hashCode(this.colorRgb);
        hash = 83 * hash + (this.fg ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fill other = (Fill)obj;
        if (!Objects.equals(this.patternType, other.patternType)) {
            return false;
        }
        if (!Objects.equals(this.colorRgb, other.colorRgb)) {
            return false;
        }
        return this.fg == other.fg;
    }

    void write(Writer w) throws IOException {
        w.append("<fill><patternFill patternType=\"").append(this.patternType).append('\"');
        if (this.colorRgb == null) {
            w.append("/>");
        } else {
            w.append("><").append(this.fg ? "fg" : "bg").append("Color rgb=\"").append(this.colorRgb).append("\"/></patternFill>");
        }
        w.append("</fill>");
    }
}

