/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.util.Objects;
import top.jfunc.common.fastexcel.Writer;

class Font {
    static final Font DEFAULT = Font.build(false, false, "000000");
    private final boolean bold;
    private final boolean italic;
    private final String name;
    private final int family;
    private final double size;
    private final String rgbColor;

    Font(boolean bold, boolean italic, String name, int family, double size, String rgbColor) {
        this.bold = bold;
        this.italic = italic;
        this.name = name;
        this.family = family;
        this.size = size;
        this.rgbColor = rgbColor;
    }

    static Font build(boolean bold, boolean italic, String rgbColor) {
        return new Font(bold, italic, "Calibri", 2, 11.0, rgbColor);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.bold ? 1 : 0);
        hash = 83 * hash + (this.italic ? 1 : 0);
        hash = 83 * hash + Objects.hashCode(this.name);
        hash = 83 * hash + this.family;
        hash = 83 * hash + Objects.hashCode(this.size);
        hash = 83 * hash + Objects.hashCode(this.rgbColor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Font other = (Font)obj;
        if (this.bold != other.bold) {
            return false;
        }
        if (this.italic != other.italic) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (this.family != other.family) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return Objects.equals(this.rgbColor, other.rgbColor);
    }

    void write(Writer w) throws IOException {
        w.append("<font>").append(this.bold ? "<b/>" : "").append(this.italic ? "<i/>" : "").append("<sz val=\"").append(this.size).append("\"/>");
        if (this.rgbColor != null) {
            w.append("<color rgb=\"").append(this.rgbColor).append("\"/>");
        }
        w.append("<name val=\"").appendEscaped(this.name).append("\"/></font>");
    }
}

