/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import top.jfunc.common.fastexcel.Cell;
import top.jfunc.common.fastexcel.Fill;
import top.jfunc.common.fastexcel.StyleSetter;
import top.jfunc.common.fastexcel.Worksheet;

public class Range {
    private final Worksheet worksheet;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;

    Range(Worksheet worksheet, int top, int left, int bottom, int right) {
        this.worksheet = Objects.requireNonNull(worksheet);
        this.top = top <= bottom ? top : bottom;
        this.left = left <= right ? left : right;
        this.bottom = bottom >= top ? bottom : top;
        this.right = right >= left ? right : left;
    }

    public Worksheet getWorksheet() {
        return this.worksheet;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRight() {
        return this.right;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.worksheet);
        hash = 59 * hash + this.top;
        hash = 59 * hash + this.left;
        hash = 59 * hash + this.bottom;
        hash = 59 * hash + this.right;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (!Objects.equals(this.worksheet, other.worksheet)) {
            return false;
        }
        if (this.top != other.top) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.bottom != other.bottom) {
            return false;
        }
        return this.right == other.right;
    }

    public static String colToString(int c) {
        StringBuffer sb = new StringBuffer();
        while (c >= 0) {
            sb.append((char)(65 + c % 26));
            c = c / 26 - 1;
        }
        return sb.reverse().toString();
    }

    public String toString() {
        return Range.colToString(this.left) + Integer.toString(this.top + 1) + ':' + Range.colToString(this.right) + Integer.toString(this.bottom + 1);
    }

    public StyleSetter style() {
        return new StyleSetter(this);
    }

    public void merge() {
        this.worksheet.merge(this);
    }

    public boolean contains(int r, int c) {
        return r >= this.top && r <= this.bottom && c >= this.left && c <= this.right;
    }

    public void shadeAlternateRows(Fill fill) {
        this.worksheet.shadeAlternateRows(this, fill);
    }

    Set<Integer> getStyles() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int r = this.top; r <= this.bottom; ++r) {
            for (int c = this.left; c <= this.right; ++c) {
                result.add(this.getWorksheet().cell((int)r, (int)c).style);
            }
        }
        return result;
    }

    void applyStyle(Map<Integer, Integer> styles) {
        for (int r = this.top; r <= this.bottom; ++r) {
            for (int c = this.left; c <= this.right; ++c) {
                Cell cell = this.getWorksheet().cell(r, c);
                cell.style = styles.get(cell.style);
            }
        }
    }
}

